/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.delete;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.CompositeIndicesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.DocWriteRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ValidateActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.VersionType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;

public class DeleteRequest
extends ReplicatedWriteRequest<DeleteRequest>
implements DocWriteRequest<DeleteRequest>,
CompositeIndicesRequest {
    private static final ShardId NO_SHARD_ID = null;
    private String type;
    private String id;
    @Nullable
    private String routing;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;

    public DeleteRequest(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        if (in.getVersion().before(Version.V_7_0_0)) {
            in.readOptionalString();
        }
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.ifSeqNo = in.readZLong();
            this.ifPrimaryTerm = in.readVLong();
        } else {
            this.ifSeqNo = -2L;
            this.ifPrimaryTerm = 0L;
        }
    }

    public DeleteRequest() {
        super(NO_SHARD_ID);
    }

    public DeleteRequest(String index) {
        super(NO_SHARD_ID);
        this.index = index;
    }

    @Deprecated
    public DeleteRequest(String index, String type, String id) {
        super(NO_SHARD_ID);
        this.index = index;
        this.type = type;
        this.id = id;
    }

    public DeleteRequest(String index, String id) {
        super(NO_SHARD_ID);
        this.index = index;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (Strings.isEmpty(this.type())) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (Strings.isEmpty(this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        validationException = DocWriteRequest.validateSeqNoBasedCASParams(this, validationException);
        return validationException;
    }

    @Override
    @Deprecated
    public String type() {
        if (this.type == null) {
            return "_doc";
        }
        return this.type;
    }

    @Override
    @Deprecated
    public DeleteRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Deprecated
    public DeleteRequest defaultTypeIfNull(String defaultType) {
        if (Strings.isNullOrEmpty(this.type)) {
            this.type = defaultType;
        }
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    public DeleteRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public DeleteRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    @Override
    public DeleteRequest version(long version) {
        this.version = version;
        return this;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public DeleteRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    @Override
    public long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Override
    public long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Override
    public DeleteRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    @Override
    public DeleteRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    @Override
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public DocWriteRequest.OpType opType() {
        return DocWriteRequest.OpType.DELETE;
    }

    @Override
    public void readFrom(StreamInput in) {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type());
        out.writeString(this.id);
        out.writeOptionalString(this.routing());
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalString(null);
        }
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeZLong(this.ifSeqNo);
            out.writeVLong(this.ifPrimaryTerm);
        } else if (this.ifSeqNo != -2L || this.ifPrimaryTerm != 0L) {
            assert (false) : "setIfMatch [" + this.ifSeqNo + "], currentDocTem [" + this.ifPrimaryTerm + "]";
            throw new IllegalStateException("sequence number based compare and write is not supported until all nodes are on version 7.0 or higher. Stream version [" + out.getVersion() + "]");
        }
    }

    @Override
    public String toString() {
        return "delete {[" + this.index + "][" + this.type() + "][" + this.id + "]}";
    }
}

