/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.bulk;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.DocWriteResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.bulk.BulkItemResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.WriteResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.ReplicationResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;

public class BulkShardResponse
extends ReplicationResponse
implements WriteResponse {
    private ShardId shardId;
    private BulkItemResponse[] responses;

    BulkShardResponse() {
    }

    public BulkShardResponse(ShardId shardId, BulkItemResponse[] responses) {
        this.shardId = shardId;
        this.responses = responses;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BulkItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public void setForcedRefresh(boolean forcedRefresh) {
        for (BulkItemResponse response : this.responses) {
            Object r = response.getResponse();
            if (r == null) continue;
            ((DocWriteResponse)r).setForcedRefresh(forcedRefresh);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = new ShardId(in);
        this.responses = new BulkItemResponse[in.readVInt()];
        for (int i = 0; i < this.responses.length; ++i) {
            this.responses[i] = BulkItemResponse.readBulkItem(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeVInt(this.responses.length);
        for (BulkItemResponse response : this.responses) {
            response.writeTo(out);
        }
    }
}

