/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Streamable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.CommitStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.seqno.SeqNoStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardPath;

public class ShardStats
implements Streamable,
Writeable,
ToXContentFragment {
    private ShardRouting shardRouting;
    private CommonStats commonStats;
    @Nullable
    private CommitStats commitStats;
    @Nullable
    private SeqNoStats seqNoStats;
    @Nullable
    private RetentionLeaseStats retentionLeaseStats;
    private String dataPath;
    private String statePath;
    private boolean isCustomDataPath;

    public RetentionLeaseStats getRetentionLeaseStats() {
        return this.retentionLeaseStats;
    }

    ShardStats() {
    }

    public ShardStats(ShardRouting routing, ShardPath shardPath, CommonStats commonStats, CommitStats commitStats, SeqNoStats seqNoStats, RetentionLeaseStats retentionLeaseStats) {
        this.shardRouting = routing;
        this.dataPath = shardPath.getRootDataPath().toString();
        this.statePath = shardPath.getRootStatePath().toString();
        this.isCustomDataPath = shardPath.isCustomDataPath();
        this.commitStats = commitStats;
        this.commonStats = commonStats;
        this.seqNoStats = seqNoStats;
        this.retentionLeaseStats = retentionLeaseStats;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public CommonStats getStats() {
        return this.commonStats;
    }

    @Nullable
    public CommitStats getCommitStats() {
        return this.commitStats;
    }

    @Nullable
    public SeqNoStats getSeqNoStats() {
        return this.seqNoStats;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getStatePath() {
        return this.statePath;
    }

    public boolean isCustomDataPath() {
        return this.isCustomDataPath;
    }

    public static ShardStats readShardStats(StreamInput in) throws IOException {
        ShardStats stats = new ShardStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        this.commonStats = new CommonStats(in);
        this.commitStats = CommitStats.readOptionalCommitStatsFrom(in);
        this.statePath = in.readString();
        this.dataPath = in.readString();
        this.isCustomDataPath = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            this.seqNoStats = in.readOptionalWriteable(SeqNoStats::new);
        }
        if (in.getVersion().onOrAfter(Version.V_6_7_0)) {
            this.retentionLeaseStats = in.readOptionalWriteable(RetentionLeaseStats::new);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        this.commonStats.writeTo(out);
        out.writeOptionalStreamable(this.commitStats);
        out.writeString(this.statePath);
        out.writeString(this.dataPath);
        out.writeBoolean(this.isCustomDataPath);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            out.writeOptionalWriteable(this.seqNoStats);
        }
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeOptionalWriteable(this.retentionLeaseStats);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("routing").field("state", (Object)this.shardRouting.state()).field("primary", this.shardRouting.primary()).field("node", this.shardRouting.currentNodeId()).field("relocating_node", this.shardRouting.relocatingNodeId()).endObject();
        this.commonStats.toXContent(builder, params);
        if (this.commitStats != null) {
            this.commitStats.toXContent(builder, params);
        }
        if (this.seqNoStats != null) {
            this.seqNoStats.toXContent(builder, params);
        }
        if (this.retentionLeaseStats != null) {
            this.retentionLeaseStats.toXContent(builder, params);
        }
        builder.startObject("shard_path");
        builder.field("state_path", this.statePath);
        builder.field("data_path", this.dataPath);
        builder.field("is_custom_data_path", this.isCustomDataPath);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String ROUTING = "routing";
        static final String STATE = "state";
        static final String STATE_PATH = "state_path";
        static final String DATA_PATH = "data_path";
        static final String IS_CUSTOM_DATA_PATH = "is_custom_data_path";
        static final String SHARD_PATH = "shard_path";
        static final String PRIMARY = "primary";
        static final String NODE = "node";
        static final String RELOCATING_NODE = "relocating_node";

        Fields() {
        }
    }
}

