/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.shrink;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.IndicesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ValidateActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.alias.Alias;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActiveShardCount;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class ResizeRequest
extends AcknowledgedRequest<ResizeRequest>
implements IndicesRequest,
ToXContentObject {
    public static final ObjectParser<ResizeRequest, Void> PARSER = new ObjectParser("resize_request", null);
    private CreateIndexRequest targetIndexRequest;
    private String sourceIndex;
    private ResizeType type = ResizeType.SHRINK;
    private Boolean copySettings = true;

    ResizeRequest() {
    }

    public ResizeRequest(String targetIndex, String sourceIndex) {
        this.targetIndexRequest = new CreateIndexRequest(targetIndex);
        this.sourceIndex = sourceIndex;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException;
        ActionRequestValidationException actionRequestValidationException = validationException = this.targetIndexRequest == null ? null : this.targetIndexRequest.validate();
        if (this.sourceIndex == null) {
            validationException = ValidateActions.addValidationError("source index is missing", validationException);
        }
        if (this.targetIndexRequest == null) {
            validationException = ValidateActions.addValidationError("target index request is missing", validationException);
        }
        if (!this.targetIndexRequest.settings().getByPrefix("index.sort.").isEmpty()) {
            validationException = ValidateActions.addValidationError("can't override index sort when resizing an index", validationException);
        }
        if (this.type == ResizeType.SPLIT && !IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(this.targetIndexRequest.settings())) {
            validationException = ValidateActions.addValidationError("index.number_of_shards is required for split operations", validationException);
        }
        assert (this.copySettings == null || this.copySettings.booleanValue());
        return validationException;
    }

    public void setSourceIndex(String index) {
        this.sourceIndex = index;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.targetIndexRequest = new CreateIndexRequest();
        this.targetIndexRequest.readFrom(in);
        this.sourceIndex = in.readString();
        this.type = in.getVersion().onOrAfter(ResizeAction.COMPATIBILITY_VERSION) ? in.readEnum(ResizeType.class) : ResizeType.SHRINK;
        this.copySettings = in.getVersion().before(Version.V_6_4_0) ? null : in.readOptionalBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.targetIndexRequest.writeTo(out);
        out.writeString(this.sourceIndex);
        if (out.getVersion().onOrAfter(ResizeAction.COMPATIBILITY_VERSION)) {
            out.writeEnum(this.type);
        }
        if (!out.getVersion().before(Version.V_6_4_0)) {
            out.writeOptionalBoolean(this.copySettings);
        }
    }

    @Override
    public String[] indices() {
        return new String[]{this.sourceIndex};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandOpen();
    }

    public void setTargetIndex(CreateIndexRequest targetIndexRequest) {
        this.targetIndexRequest = Objects.requireNonNull(targetIndexRequest, "target index request must not be null");
    }

    public CreateIndexRequest getTargetIndexRequest() {
        return this.targetIndexRequest;
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public void setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.getTargetIndexRequest().waitForActiveShards(waitForActiveShards);
    }

    public void setWaitForActiveShards(int waitForActiveShards) {
        this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public void setResizeType(ResizeType type) {
        this.type = Objects.requireNonNull(type);
    }

    public ResizeType getResizeType() {
        return this.type;
    }

    public void setCopySettings(Boolean copySettings) {
        if (copySettings != null && !copySettings.booleanValue()) {
            throw new IllegalArgumentException("[copySettings] can not be explicitly set to [false]");
        }
        this.copySettings = copySettings;
    }

    public Boolean getCopySettings() {
        return this.copySettings;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(CreateIndexRequest.SETTINGS.getPreferredName());
        this.targetIndexRequest.settings().toXContent(builder, params);
        builder.endObject();
        builder.startObject(CreateIndexRequest.ALIASES.getPreferredName());
        for (Alias alias : this.targetIndexRequest.aliases()) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public void fromXContent(XContentParser parser) throws IOException {
        PARSER.parse(parser, this, null);
    }

    static {
        PARSER.declareField((parser, request, context) -> request.getTargetIndexRequest().settings(parser.map()), new ParseField("settings", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.getTargetIndexRequest().aliases(parser.map()), new ParseField("aliases", new String[0]), ObjectParser.ValueType.OBJECT);
    }
}

