/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.mapping.put;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.RequestValidators;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexNotFoundException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class TransportPutMappingAction
extends TransportMasterNodeAction<PutMappingRequest, AcknowledgedResponse> {
    private final MetaDataMappingService metaDataMappingService;
    private final RequestValidators<PutMappingRequest> requestValidators;

    @Inject
    public TransportPutMappingAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataMappingService metaDataMappingService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RequestValidators<PutMappingRequest> requestValidators) {
        super("indices:admin/mapping/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutMappingRequest::new);
        this.metaDataMappingService = metaDataMappingService;
        this.requestValidators = Objects.requireNonNull(requestValidators);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected AcknowledgedResponse newResponse() {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    @Override
    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices = request.getConcreteIndex() == null ? this.indexNameExpressionResolver.concreteIndexNames(state, request) : new String[]{request.getConcreteIndex().getName()};
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected void masterOperation(final PutMappingRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        try {
            Index[] indexArray;
            if (request.getConcreteIndex() == null) {
                indexArray = this.indexNameExpressionResolver.concreteIndices(state, request);
            } else {
                Index[] indexArray2 = new Index[1];
                indexArray = indexArray2;
                indexArray2[0] = request.getConcreteIndex();
            }
            final Index[] concreteIndices = indexArray;
            Optional<Exception> maybeValidationException = this.requestValidators.validateRequest(request, state, concreteIndices);
            if (maybeValidationException.isPresent()) {
                listener.onFailure(maybeValidationException.get());
                return;
            }
            PutMappingClusterStateUpdateRequest updateRequest = ((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)new PutMappingClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices)).type(request.type()).source(request.source());
            this.metaDataMappingService.putMapping(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

                @Override
                public void onResponse(ClusterStateUpdateResponse response) {
                    listener.onResponse(new AcknowledgedResponse(response.isAcknowledged()));
                }

                @Override
                public void onFailure(Exception t) {
                    TransportPutMappingAction.this.logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}], type [{}]", (Object)concreteIndices, (Object)request.type()), (Throwable)t);
                    listener.onFailure(t);
                }
            });
        }
        catch (IndexNotFoundException ex) {
            this.logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}], type [{}]", (Object)request.indices(), (Object)request.type()), (Throwable)ex);
            throw ex;
        }
    }
}

