/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.flush;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.flush.ShardFlushRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.ReplicationResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.IndicesService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class TransportShardFlushAction
extends TransportReplicationAction<ShardFlushRequest, ShardFlushRequest, ReplicationResponse> {
    public static final String NAME = "indices:admin/flush[s]";

    @Inject
    public TransportShardFlushAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, ShardFlushRequest::new, ShardFlushRequest::new, "flush");
    }

    @Override
    protected ReplicationResponse newResponseInstance() {
        return new ReplicationResponse();
    }

    @Override
    protected void shardOperationOnPrimary(ShardFlushRequest shardRequest, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ShardFlushRequest, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            primary.flush(shardRequest.getRequest());
            this.logger.trace("{} flush request executed on primary", (Object)primary.shardId());
            return new TransportReplicationAction.PrimaryResult<ShardFlushRequest, ReplicationResponse>(shardRequest, new ReplicationResponse());
        });
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(ShardFlushRequest request, IndexShard replica) {
        replica.flush(request.getRequest());
        this.logger.trace("{} flush request executed on replica", (Object)replica.shardId());
        return new TransportReplicationAction.ReplicaResult();
    }
}

