/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class ClusterUpdateSettingsResponse
extends AcknowledgedResponse {
    private static final ParseField PERSISTENT = new ParseField("persistent", new String[0]);
    private static final ParseField TRANSIENT = new ParseField("transient", new String[0]);
    private static final ConstructingObjectParser<ClusterUpdateSettingsResponse, Void> PARSER = new ConstructingObjectParser("cluster_update_settings_response", true, args -> new ClusterUpdateSettingsResponse((Boolean)args[0], (Settings)args[1], (Settings)args[2]));
    final Settings transientSettings;
    final Settings persistentSettings;

    ClusterUpdateSettingsResponse(StreamInput in) throws IOException {
        super(in, in.getVersion().onOrAfter(Version.V_6_4_0));
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
        } else {
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.acknowledged = in.readBoolean();
        }
    }

    ClusterUpdateSettingsResponse(boolean acknowledged, Settings transientSettings, Settings persistentSettings) {
        super(acknowledged);
        this.persistentSettings = persistentSettings;
        this.transientSettings = transientSettings;
    }

    public Settings getTransientSettings() {
        return this.transientSettings;
    }

    public Settings getPersistentSettings() {
        return this.persistentSettings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            super.writeTo(out);
            Settings.writeSettingsToStream(this.transientSettings, out);
            Settings.writeSettingsToStream(this.persistentSettings, out);
        } else {
            Settings.writeSettingsToStream(this.transientSettings, out);
            Settings.writeSettingsToStream(this.persistentSettings, out);
            out.writeBoolean(this.acknowledged);
        }
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(PERSISTENT.getPreferredName());
        this.persistentSettings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(TRANSIENT.getPreferredName());
        this.transientSettings.toXContent(builder, params);
        builder.endObject();
    }

    public static ClusterUpdateSettingsResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            ClusterUpdateSettingsResponse that = (ClusterUpdateSettingsResponse)o;
            return Objects.equals(this.transientSettings, that.transientSettings) && Objects.equals(this.persistentSettings, that.persistentSettings);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.transientSettings, this.persistentSettings);
    }

    static {
        ClusterUpdateSettingsResponse.declareAcknowledgedField(PARSER);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), TRANSIENT);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), PERSISTENT);
    }
}

