/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.get;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ResourceNotFoundException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get.GetRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get.GetResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.HandledTransportAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.OriginSettingClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexNotFoundException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.TaskInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.TaskResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponseHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class TransportGetTaskAction
extends HandledTransportAction<GetTaskRequest, GetTaskResponse> {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportGetTaskAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:monitor/task/get", transportService, actionFilters, GetTaskRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.client = new OriginSettingClient(client, "tasks");
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    protected void doExecute(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        if (this.clusterService.localNode().getId().equals(request.getTaskId().getNodeId())) {
            this.getRunningTaskFromNode(thisTask, request, listener);
        } else {
            this.runOnNodeWithTaskIfPossible(thisTask, request, listener);
        }
    }

    private void runOnNodeWithTaskIfPossible(Task thisTask, GetTaskRequest request, final ActionListener<GetTaskResponse> listener) {
        DiscoveryNode node;
        TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
        if (request.getTimeout() != null) {
            builder.withTimeout(request.getTimeout());
        }
        if ((node = this.clusterService.state().nodes().get(request.getTaskId().getNodeId())) == null) {
            this.getFinishedTaskFromIndex(thisTask, request, ActionListener.wrap(listener::onResponse, e -> {
                if (e instanceof ResourceNotFoundException) {
                    e = new ResourceNotFoundException("task [" + request.getTaskId() + "] belongs to the node [" + request.getTaskId().getNodeId() + "] which isn't part of the cluster and there is no record of the task", (Throwable)e, new Object[0]);
                }
                listener.onFailure((Exception)e);
            }));
            return;
        }
        GetTaskRequest nodeRequest = request.nodeRequest(this.clusterService.localNode().getId(), thisTask.getId());
        this.transportService.sendRequest(node, "cluster:monitor/task/get", (TransportRequest)nodeRequest, builder.build(), new TransportResponseHandler<GetTaskResponse>(){

            @Override
            public GetTaskResponse read(StreamInput in) throws IOException {
                GetTaskResponse response = new GetTaskResponse();
                response.readFrom(in);
                return response;
            }

            @Override
            public void handleResponse(GetTaskResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }

            @Override
            public String executor() {
                return "same";
            }
        });
    }

    void getRunningTaskFromNode(final Task thisTask, final GetTaskRequest request, final ActionListener<GetTaskResponse> listener) {
        final Task runningTask = this.taskManager.getTask(request.getTaskId().getId());
        if (runningTask == null) {
            this.getFinishedTaskFromIndex(thisTask, request, listener);
        } else if (request.getWaitForCompletion()) {
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                protected void doRun() {
                    TransportGetTaskAction.this.taskManager.waitForTaskCompletion(runningTask, TransportListTasksAction.waitForCompletionTimeout(request.getTimeout()));
                    TransportGetTaskAction.this.waitedForCompletion(thisTask, request, runningTask.taskInfo(TransportGetTaskAction.this.clusterService.localNode().getId(), true), listener);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            TaskInfo info = runningTask.taskInfo(this.clusterService.localNode().getId(), true);
            listener.onResponse(new GetTaskResponse(new TaskResult(false, info)));
        }
    }

    void waitedForCompletion(Task thisTask, GetTaskRequest request, TaskInfo snapshotOfRunningTask, ActionListener<GetTaskResponse> listener) {
        this.getFinishedTaskFromIndex(thisTask, request, ActionListener.delegateResponse(listener, (delegatedListener, e) -> {
            if (ExceptionsHelper.unwrap(e, ResourceNotFoundException.class) != null) {
                delegatedListener.onResponse(new GetTaskResponse(new TaskResult(true, snapshotOfRunningTask)));
            } else {
                delegatedListener.onFailure((Exception)e);
            }
        }));
    }

    void getFinishedTaskFromIndex(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        GetRequest get = new GetRequest(".tasks", "task", request.getTaskId().toString());
        get.setParentTask(this.clusterService.localNode().getId(), thisTask.getId());
        this.client.get(get, ActionListener.wrap(r -> this.onGetFinishedTaskFromIndex((GetResponse)r, listener), e -> {
            if (ExceptionsHelper.unwrap(e, IndexNotFoundException.class) != null) {
                listener.onFailure(new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", (Throwable)e, request.getTaskId()));
            } else {
                listener.onFailure((Exception)e);
            }
        }));
    }

    void onGetFinishedTaskFromIndex(GetResponse response, ActionListener<GetTaskResponse> listener) throws IOException {
        if (!response.isExists()) {
            listener.onFailure(new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", response.getId()));
            return;
        }
        if (response.isSourceEmpty()) {
            listener.onFailure(new ElasticsearchException("Stored task status for [{}] didn't contain any source!", response.getId()));
            return;
        }
        try (XContentParser parser = XContentHelper.createParser(this.xContentRegistry, LoggingDeprecationHandler.INSTANCE, response.getSourceAsBytesRef());){
            TaskResult result = TaskResult.PARSER.apply(parser, null);
            listener.onResponse(new GetTaskResponse(result));
        }
    }
}

