/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.cancel;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ResourceNotFoundException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.FailedNodeException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.TaskOperationFailure;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.CancellableTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.TaskId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.TaskInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class TransportCancelTasksAction
extends TransportTasksAction<CancellableTask, CancelTasksRequest, CancelTasksResponse, TaskInfo> {
    public static final String BAN_PARENT_ACTION_NAME = "internal:admin/tasks/ban";

    @Inject
    public TransportCancelTasksAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/tasks/cancel", clusterService, transportService, actionFilters, CancelTasksRequest::new, CancelTasksResponse::new, TaskInfo::new, "management");
        transportService.registerRequestHandler(BAN_PARENT_ACTION_NAME, "same", x$0 -> new BanParentTaskRequest(x$0), new BanParentRequestHandler());
    }

    @Override
    protected CancelTasksResponse newResponse(CancelTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new CancelTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void processTasks(CancelTasksRequest request, Consumer<CancellableTask> operation) {
        if (request.getTaskId().isSet()) {
            CancellableTask task = this.taskManager.getCancellableTask(request.getTaskId().getId());
            if (task != null) {
                if (!request.match(task)) throw new IllegalArgumentException("task [" + request.getTaskId() + "] doesn't support this operation");
                operation.accept(task);
                return;
            }
            if (this.taskManager.getTask(request.getTaskId().getId()) != null) {
                throw new IllegalArgumentException("task [" + request.getTaskId() + "] doesn't support cancellation");
            }
            throw new ResourceNotFoundException("task [{}] doesn't support cancellation", request.getTaskId());
        }
        Iterator<CancellableTask> iterator = this.taskManager.getCancellableTasks().values().iterator();
        while (iterator.hasNext()) {
            CancellableTask task = iterator.next();
            if (!request.match(task)) continue;
            operation.accept(task);
        }
    }

    @Override
    protected synchronized void taskOperation(CancelTasksRequest request, final CancellableTask cancellableTask, final ActionListener<TaskInfo> listener) {
        boolean canceled;
        final String nodeId = this.clusterService.localNode().getId();
        if (cancellableTask.shouldCancelChildrenOnCancellation()) {
            DiscoveryNodes childNodes = this.clusterService.state().nodes();
            final BanLock banLock = new BanLock(childNodes.getSize(), () -> this.removeBanOnNodes(cancellableTask, childNodes));
            canceled = this.taskManager.cancel(cancellableTask, request.getReason(), banLock::onTaskFinished);
            if (canceled) {
                this.logger.trace("cancelling task {} on child nodes", (Object)cancellableTask.getId());
                final AtomicInteger responses = new AtomicInteger(childNodes.getSize());
                final ArrayList failures = new ArrayList();
                this.setBanOnNodes(request.getReason(), cancellableTask, childNodes, new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void aVoid) {
                        this.processResponse();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Exception e) {
                        List list = failures;
                        synchronized (list) {
                            failures.add(e);
                        }
                        this.processResponse();
                    }

                    private void processResponse() {
                        banLock.onBanSet();
                        if (responses.decrementAndGet() == 0) {
                            if (!failures.isEmpty()) {
                                IllegalStateException exception = new IllegalStateException("failed to cancel children of the task [" + cancellableTask.getId() + "]");
                                failures.forEach(exception::addSuppressed);
                                listener.onFailure(exception);
                            } else {
                                listener.onResponse(cancellableTask.taskInfo(nodeId, false));
                            }
                        }
                    }
                });
            }
        } else {
            canceled = this.taskManager.cancel(cancellableTask, request.getReason(), () -> listener.onResponse(cancellableTask.taskInfo(nodeId, false)));
            if (canceled) {
                this.logger.trace("task {} doesn't have any children that should be cancelled", (Object)cancellableTask.getId());
            }
        }
        if (!canceled) {
            this.logger.trace("task {} is already cancelled", (Object)cancellableTask.getId());
            throw new IllegalStateException("task with id " + cancellableTask.getId() + " is already cancelled");
        }
    }

    private void setBanOnNodes(String reason, CancellableTask task, DiscoveryNodes nodes, ActionListener<Void> listener) {
        this.sendSetBanRequest(nodes, BanParentTaskRequest.createSetBanParentTaskRequest(new TaskId(this.clusterService.localNode().getId(), task.getId()), reason), listener);
    }

    private void removeBanOnNodes(CancellableTask task, DiscoveryNodes nodes) {
        this.sendRemoveBanRequest(nodes, BanParentTaskRequest.createRemoveBanParentTaskRequest(new TaskId(this.clusterService.localNode().getId(), task.getId())));
    }

    private void sendSetBanRequest(DiscoveryNodes nodes, final BanParentTaskRequest request, final ActionListener<Void> listener) {
        for (final ObjectObjectCursor<String, DiscoveryNode> objectObjectCursor : nodes.getNodes()) {
            this.logger.trace("Sending ban for tasks with the parent [{}] to the node [{}], ban [{}]", (Object)request.parentTaskId, objectObjectCursor.key, (Object)request.ban);
            this.transportService.sendRequest((DiscoveryNode)objectObjectCursor.value, BAN_PARENT_ACTION_NAME, request, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    listener.onResponse(null);
                }

                @Override
                public void handleException(TransportException exp) {
                    TransportCancelTasksAction.this.logger.warn("Cannot send ban for tasks with the parent [{}] to the node [{}]", (Object)request.parentTaskId, objectObjectCursor.key);
                    listener.onFailure(exp);
                }
            });
        }
    }

    private void sendRemoveBanRequest(DiscoveryNodes nodes, BanParentTaskRequest request) {
        for (ObjectObjectCursor<String, DiscoveryNode> objectObjectCursor : nodes.getNodes()) {
            this.logger.debug("Sending remove ban for tasks with the parent [{}] to the node [{}]", (Object)request.parentTaskId, objectObjectCursor.key);
            this.transportService.sendRequest((DiscoveryNode)objectObjectCursor.value, BAN_PARENT_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    class BanParentRequestHandler
    implements TransportRequestHandler<BanParentTaskRequest> {
        BanParentRequestHandler() {
        }

        @Override
        public void messageReceived(BanParentTaskRequest request, TransportChannel channel, Task task) throws Exception {
            if (request.ban) {
                TransportCancelTasksAction.this.logger.debug("Received ban for the parent [{}] on the node [{}], reason: [{}]", (Object)request.parentTaskId, (Object)TransportCancelTasksAction.this.clusterService.localNode().getId(), (Object)request.reason);
                TransportCancelTasksAction.this.taskManager.setBan(request.parentTaskId, request.reason);
            } else {
                TransportCancelTasksAction.this.logger.debug("Removing ban for the parent [{}] on the node [{}]", (Object)request.parentTaskId, (Object)TransportCancelTasksAction.this.clusterService.localNode().getId());
                TransportCancelTasksAction.this.taskManager.removeBan(request.parentTaskId);
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    private static class BanParentTaskRequest
    extends TransportRequest {
        private final TaskId parentTaskId;
        private final boolean ban;
        private final String reason;

        static BanParentTaskRequest createSetBanParentTaskRequest(TaskId parentTaskId, String reason) {
            return new BanParentTaskRequest(parentTaskId, reason);
        }

        static BanParentTaskRequest createRemoveBanParentTaskRequest(TaskId parentTaskId) {
            return new BanParentTaskRequest(parentTaskId);
        }

        private BanParentTaskRequest(TaskId parentTaskId, String reason) {
            this.parentTaskId = parentTaskId;
            this.ban = true;
            this.reason = reason;
        }

        private BanParentTaskRequest(TaskId parentTaskId) {
            this.parentTaskId = parentTaskId;
            this.ban = false;
            this.reason = null;
        }

        private BanParentTaskRequest(StreamInput in) throws IOException {
            super(in);
            this.parentTaskId = TaskId.readFromStream(in);
            this.ban = in.readBoolean();
            this.reason = this.ban ? in.readString() : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.parentTaskId.writeTo(out);
            out.writeBoolean(this.ban);
            if (this.ban) {
                out.writeString(this.reason);
            }
        }
    }

    private static class BanLock {
        private final Runnable finish;
        private final AtomicInteger counter = new AtomicInteger(0);
        private final int nodesSize;

        BanLock(int nodesSize, Runnable finish) {
            this.finish = finish;
            this.nodesSize = nodesSize;
        }

        public void onBanSet() {
            if (this.counter.decrementAndGet() == 0) {
                this.finish();
            }
        }

        public void onTaskFinished() {
            if (this.counter.addAndGet(this.nodesSize) == 0) {
                this.finish();
            }
        }

        public void finish() {
            this.finish.run();
        }
    }
}

