/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.FailedNodeException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.node.NodeService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class TransportNodesInfoAction
extends TransportNodesAction<NodesInfoRequest, NodesInfoResponse, NodeInfoRequest, NodeInfo> {
    private final NodeService nodeService;

    @Inject
    public TransportNodesInfoAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, ActionFilters actionFilters) {
        super("cluster:monitor/nodes/info", threadPool, clusterService, transportService, actionFilters, NodesInfoRequest::new, NodeInfoRequest::new, "management", NodeInfo.class);
        this.nodeService = nodeService;
    }

    @Override
    protected NodesInfoResponse newResponse(NodesInfoRequest nodesInfoRequest, List<NodeInfo> responses, List<FailedNodeException> failures) {
        return new NodesInfoResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeInfoRequest newNodeRequest(NodesInfoRequest request) {
        return new NodeInfoRequest(request);
    }

    @Override
    protected NodeInfo newNodeResponse() {
        return new NodeInfo();
    }

    @Override
    protected NodeInfo nodeOperation(NodeInfoRequest nodeRequest) {
        NodesInfoRequest request = nodeRequest.request;
        return this.nodeService.info(request.settings(), request.os(), request.process(), request.jvm(), request.threadPool(), request.transport(), request.http(), request.plugins(), request.ingest(), request.indices());
    }

    public static class NodeInfoRequest
    extends BaseNodeRequest {
        NodesInfoRequest request;

        public NodeInfoRequest() {
        }

        public NodeInfoRequest(NodesInfoRequest request) {
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new NodesInfoRequest();
            this.request.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

