/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.OfflinePointReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointValue;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointWriter;

public final class OfflinePointWriter
implements PointWriter {
    final Directory tempDir;
    public final IndexOutput out;
    public final String name;
    final int packedBytesLength;
    long count;
    private boolean closed;
    final long expectedCount;

    public OfflinePointWriter(Directory tempDir, String tempFileNamePrefix, int packedBytesLength, String desc, long expectedCount) throws IOException {
        this.out = tempDir.createTempOutput(tempFileNamePrefix, "bkd_" + desc, IOContext.DEFAULT);
        this.name = this.out.getName();
        this.tempDir = tempDir;
        this.packedBytesLength = packedBytesLength;
        this.expectedCount = expectedCount;
    }

    @Override
    public void append(byte[] packedValue, int docID) throws IOException {
        assert (!this.closed) : "Point writer is already closed";
        assert (packedValue.length == this.packedBytesLength) : "[packedValue] must have length [" + this.packedBytesLength + "] but was [" + packedValue.length + "]";
        this.out.writeBytes(packedValue, 0, packedValue.length);
        this.out.writeInt(docID);
        ++this.count;
        assert (this.expectedCount == 0L || this.count <= this.expectedCount) : "expectedCount=" + this.expectedCount + " vs count=" + this.count;
    }

    @Override
    public void append(PointValue pointValue) throws IOException {
        assert (!this.closed) : "Point writer is already closed";
        BytesRef packedValue = pointValue.packedValue();
        assert (packedValue.length == this.packedBytesLength) : "[packedValue] must have length [" + this.packedBytesLength + "] but was [" + packedValue.length + "]";
        this.out.writeBytes(packedValue.bytes, packedValue.offset, packedValue.length);
        BytesRef docIDBytes = pointValue.docIDBytes();
        assert (docIDBytes.length == 4) : "[docIDBytes] must have length [4] but was [" + docIDBytes.length + "]";
        this.out.writeBytes(docIDBytes.bytes, docIDBytes.offset, docIDBytes.length);
        ++this.count;
        assert (this.expectedCount == 0L || this.count <= this.expectedCount) : "expectedCount=" + this.expectedCount + " vs count=" + this.count;
    }

    @Override
    public PointReader getReader(long start, long length) throws IOException {
        byte[] buffer = new byte[this.packedBytesLength + 4];
        return this.getReader(start, length, buffer);
    }

    protected OfflinePointReader getReader(long start, long length, byte[] reusableBuffer) throws IOException {
        assert (this.closed) : "point writer is still open and trying to get a reader";
        assert (start + length <= this.count) : "start=" + start + " length=" + length + " count=" + this.count;
        assert (this.expectedCount == 0L || this.count == this.expectedCount);
        return new OfflinePointReader(this.tempDir, this.name, this.packedBytesLength, start, length, reusableBuffer);
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                CodecUtil.writeFooter(this.out);
            }
            finally {
                this.out.close();
                this.closed = true;
            }
        }
    }

    @Override
    public void destroy() throws IOException {
        this.tempDir.deleteFile(this.name);
    }

    public String toString() {
        return "OfflinePointWriter(count=" + this.count + " tempFileName=" + this.name + ")";
    }
}

