/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.HeapPointReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointValue;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointWriter;

public final class HeapPointWriter
implements PointWriter {
    public final int[] docIDs;
    public final byte[] block;
    final int size;
    final int packedBytesLength;
    private final byte[] scratch;
    private int nextWrite;
    private boolean closed;
    private HeapPointReader.HeapPointValue pointValue;

    public HeapPointWriter(int size, int packedBytesLength) {
        this.docIDs = new int[size];
        this.block = new byte[packedBytesLength * size];
        this.size = size;
        this.packedBytesLength = packedBytesLength;
        this.scratch = new byte[packedBytesLength];
        this.pointValue = size > 0 ? new HeapPointReader.HeapPointValue(this.block, packedBytesLength) : null;
    }

    public PointValue getPackedValueSlice(int index) {
        assert (index < this.nextWrite) : "nextWrite=" + this.nextWrite + " vs index=" + index;
        this.pointValue.setValue(index * this.packedBytesLength, this.docIDs[index]);
        return this.pointValue;
    }

    @Override
    public void append(byte[] packedValue, int docID) {
        assert (!this.closed) : "point writer is already closed";
        assert (packedValue.length == this.packedBytesLength) : "[packedValue] must have length [" + this.packedBytesLength + "] but was [" + packedValue.length + "]";
        assert (this.nextWrite < this.size) : "nextWrite=" + (this.nextWrite + 1) + " vs size=" + this.size;
        System.arraycopy(packedValue, 0, this.block, this.nextWrite * this.packedBytesLength, this.packedBytesLength);
        this.docIDs[this.nextWrite] = docID;
        ++this.nextWrite;
    }

    @Override
    public void append(PointValue pointValue) {
        assert (!this.closed) : "point writer is already closed";
        assert (this.nextWrite < this.size) : "nextWrite=" + (this.nextWrite + 1) + " vs size=" + this.size;
        BytesRef packedValue = pointValue.packedValue();
        assert (packedValue.length == this.packedBytesLength) : "[packedValue] must have length [" + this.packedBytesLength + "] but was [" + packedValue.length + "]";
        System.arraycopy(packedValue.bytes, packedValue.offset, this.block, this.nextWrite * this.packedBytesLength, this.packedBytesLength);
        this.docIDs[this.nextWrite] = pointValue.docID();
        ++this.nextWrite;
    }

    public void swap(int i, int j) {
        int docID = this.docIDs[i];
        this.docIDs[i] = this.docIDs[j];
        this.docIDs[j] = docID;
        int indexI = i * this.packedBytesLength;
        int indexJ = j * this.packedBytesLength;
        System.arraycopy(this.block, indexI, this.scratch, 0, this.packedBytesLength);
        System.arraycopy(this.block, indexJ, this.block, indexI, this.packedBytesLength);
        System.arraycopy(this.scratch, 0, this.block, indexJ, this.packedBytesLength);
    }

    @Override
    public long count() {
        return this.nextWrite;
    }

    @Override
    public PointReader getReader(long start, long length) {
        assert (this.closed) : "point writer is still open and trying to get a reader";
        assert (start + length <= (long)this.docIDs.length) : "start=" + start + " length=" + length + " docIDs.length=" + this.docIDs.length;
        assert (start + length <= (long)this.nextWrite) : "start=" + start + " length=" + length + " nextWrite=" + this.nextWrite;
        return new HeapPointReader(this.block, this.packedBytesLength, this.docIDs, (int)start, Math.toIntExact(start + length));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "HeapPointWriter(count=" + this.nextWrite + " size=" + this.docIDs.length + ")";
    }
}

