/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IntroSorter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.MSBRadixSorter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Sorter;

abstract class StringMSBRadixSorter
extends MSBRadixSorter {
    StringMSBRadixSorter() {
        super(Integer.MAX_VALUE);
    }

    protected abstract BytesRef get(int var1);

    @Override
    protected int byteAt(int i, int k) {
        BytesRef ref = this.get(i);
        if (ref.length <= k) {
            return -1;
        }
        return ref.bytes[ref.offset + k] & 0xFF;
    }

    @Override
    protected Sorter getFallbackSorter(final int k) {
        return new IntroSorter(){
            private final BytesRef pivot = new BytesRef();
            private final BytesRef scratch1 = new BytesRef();
            private final BytesRef scratch2 = new BytesRef();

            private void get(int i, int k2, BytesRef scratch) {
                BytesRef ref = StringMSBRadixSorter.this.get(i);
                assert (ref.length >= k2);
                scratch.bytes = ref.bytes;
                scratch.offset = ref.offset + k2;
                scratch.length = ref.length - k2;
            }

            @Override
            protected void swap(int i, int j) {
                StringMSBRadixSorter.this.swap(i, j);
            }

            @Override
            protected int compare(int i, int j) {
                this.get(i, k, this.scratch1);
                this.get(j, k, this.scratch2);
                return this.scratch1.compareTo(this.scratch2);
            }

            @Override
            protected void setPivot(int i) {
                this.get(i, k, this.pivot);
            }

            @Override
            protected int comparePivot(int j) {
                this.get(j, k, this.scratch2);
                return this.pivot.compareTo(this.scratch2);
            }
        };
    }
}

