/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util;

import java.util.Arrays;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BitUtil;

public final class LongBitSet {
    private final long[] bits;
    private final long numBits;
    private final int numWords;
    public static final long MAX_NUM_BITS = 64L * (long)ArrayUtil.MAX_ARRAY_LENGTH;

    public static LongBitSet ensureCapacity(LongBitSet bits, long numBits) {
        long[] arr;
        if (numBits < bits.numBits) {
            return bits;
        }
        int numWords = LongBitSet.bits2words(numBits);
        if (numWords >= (arr = bits.getBits()).length) {
            arr = ArrayUtil.grow(arr, numWords + 1);
        }
        return new LongBitSet(arr, (long)arr.length << 6);
    }

    public static int bits2words(long numBits) {
        if (numBits < 0L || numBits > MAX_NUM_BITS) {
            throw new IllegalArgumentException("numBits must be 0 .. " + MAX_NUM_BITS + "; got: " + numBits);
        }
        return (int)(numBits - 1L >> 6) + 1;
    }

    public LongBitSet(long numBits) {
        this.numBits = numBits;
        this.bits = new long[LongBitSet.bits2words(numBits)];
        this.numWords = this.bits.length;
    }

    public LongBitSet(long[] storedBits, long numBits) {
        this.numWords = LongBitSet.bits2words(numBits);
        if (this.numWords > storedBits.length) {
            throw new IllegalArgumentException("The given long array is too small  to hold " + numBits + " bits");
        }
        this.numBits = numBits;
        this.bits = storedBits;
        assert (this.verifyGhostBitsClear());
    }

    private boolean verifyGhostBitsClear() {
        for (int i = this.numWords; i < this.bits.length; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        if ((this.numBits & 0x3FL) == 0L) {
            return true;
        }
        long mask = -1L << (int)this.numBits;
        return (this.bits[this.numWords - 1] & mask) == 0L;
    }

    public long length() {
        return this.numBits;
    }

    public long[] getBits() {
        return this.bits;
    }

    public long cardinality() {
        return BitUtil.pop_array(this.bits, 0, this.numWords);
    }

    public boolean get(long index) {
        assert (index >= 0L && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int i = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        return (this.bits[i] & bitmask) != 0L;
    }

    public void set(long index) {
        assert (index >= 0L && index < this.numBits) : "index=" + index + " numBits=" + this.numBits;
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public boolean getAndSet(long index) {
        assert (index >= 0L && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    public void clear(long index) {
        assert (index >= 0L && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean getAndClear(long index) {
        assert (index >= 0L && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
        return val;
    }

    public long nextSetBit(long index) {
        assert (index >= 0L && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int i = (int)(index >> 6);
        long word = this.bits[i] >> (int)index;
        if (word != 0L) {
            return index + (long)Long.numberOfTrailingZeros(word);
        }
        while (++i < this.numWords) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + Long.numberOfTrailingZeros(word);
        }
        return -1L;
    }

    public long prevSetBit(long index) {
        assert (index >= 0L && index < this.numBits) : "index=" + index + " numBits=" + this.numBits;
        int i = (int)(index >> 6);
        int subIndex = (int)(index & 0x3FL);
        long word = this.bits[i] << 63 - subIndex;
        if (word != 0L) {
            return (i << 6) + subIndex - Long.numberOfLeadingZeros(word);
        }
        while (--i >= 0) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + 63 - Long.numberOfLeadingZeros(word);
        }
        return -1L;
    }

    public void or(LongBitSet other) {
        assert (other.numWords <= this.numWords) : "numWords=" + this.numWords + ", other.numWords=" + other.numWords;
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            int n = pos;
            this.bits[n] = this.bits[n] | other.bits[pos];
        }
    }

    public void xor(LongBitSet other) {
        assert (other.numWords <= this.numWords) : "numWords=" + this.numWords + ", other.numWords=" + other.numWords;
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            int n = pos;
            this.bits[n] = this.bits[n] ^ other.bits[pos];
        }
    }

    public boolean intersects(LongBitSet other) {
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            if ((this.bits[pos] & other.bits[pos]) == 0L) continue;
            return true;
        }
        return false;
    }

    public void and(LongBitSet other) {
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            int n = pos;
            this.bits[n] = this.bits[n] & other.bits[pos];
        }
        if (this.numWords > other.numWords) {
            Arrays.fill(this.bits, other.numWords, this.numWords, 0L);
        }
    }

    public void andNot(LongBitSet other) {
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            int n = pos;
            this.bits[n] = this.bits[n] & (other.bits[pos] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean scanIsEmpty() {
        int count = this.numWords;
        for (int i = 0; i < count; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public void flip(long startIndex, long endIndex) {
        assert (startIndex >= 0L && startIndex < this.numBits);
        assert (endIndex >= 0L && endIndex <= this.numBits);
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] ^ startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] ^ startmask;
        for (int i = startWord + 1; i < endWord; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] ^ endmask;
    }

    public void flip(long index) {
        assert (index >= 0L && index < this.numBits) : "index=" + index + " numBits=" + this.numBits;
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public void set(long startIndex, long endIndex) {
        assert (startIndex >= 0L && startIndex < this.numBits) : "startIndex=" + startIndex + ", numBits=" + this.numBits;
        assert (endIndex >= 0L && endIndex <= this.numBits) : "endIndex=" + endIndex + ", numBits=" + this.numBits;
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] | startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] | startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, -1L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] | endmask;
    }

    public void clear(long startIndex, long endIndex) {
        assert (startIndex >= 0L && startIndex < this.numBits) : "startIndex=" + startIndex + ", numBits=" + this.numBits;
        assert (endIndex >= 0L && endIndex <= this.numBits) : "endIndex=" + endIndex + ", numBits=" + this.numBits;
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, 0L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] & endmask;
    }

    public LongBitSet clone() {
        long[] bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bits, 0, this.numWords);
        return new LongBitSet(bits, this.numBits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongBitSet)) {
            return false;
        }
        LongBitSet other = (LongBitSet)o;
        if (this.numBits != other.numBits) {
            return false;
        }
        return Arrays.equals(this.bits, other.bits);
    }

    public int hashCode() {
        long h = 0L;
        int i = this.numWords;
        while (--i >= 0) {
            h ^= this.bits[i];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }
}

