/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util;

public final class BitUtil {
    private static final long[] MAGIC = new long[]{0x5555555555555555L, 0x3333333333333333L, 0xF0F0F0F0F0F0F0FL, 0xFF00FF00FF00FFL, 0xFFFF0000FFFFL, 0xFFFFFFFFL, -6148914691236517206L};
    private static final short[] SHIFT = new short[]{1, 2, 4, 8, 16};

    private BitUtil() {
    }

    public static long pop_array(long[] arr, int wordOffset, int numWords) {
        long popCount = 0L;
        int end = wordOffset + numWords;
        for (int i = wordOffset; i < end; ++i) {
            popCount += (long)Long.bitCount(arr[i]);
        }
        return popCount;
    }

    public static long pop_intersect(long[] arr1, long[] arr2, int wordOffset, int numWords) {
        long popCount = 0L;
        int end = wordOffset + numWords;
        for (int i = wordOffset; i < end; ++i) {
            popCount += (long)Long.bitCount(arr1[i] & arr2[i]);
        }
        return popCount;
    }

    public static long pop_union(long[] arr1, long[] arr2, int wordOffset, int numWords) {
        long popCount = 0L;
        int end = wordOffset + numWords;
        for (int i = wordOffset; i < end; ++i) {
            popCount += (long)Long.bitCount(arr1[i] | arr2[i]);
        }
        return popCount;
    }

    public static long pop_andnot(long[] arr1, long[] arr2, int wordOffset, int numWords) {
        long popCount = 0L;
        int end = wordOffset + numWords;
        for (int i = wordOffset; i < end; ++i) {
            popCount += (long)Long.bitCount(arr1[i] & (arr2[i] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return popCount;
    }

    public static long pop_xor(long[] arr1, long[] arr2, int wordOffset, int numWords) {
        long popCount = 0L;
        int end = wordOffset + numWords;
        for (int i = wordOffset; i < end; ++i) {
            popCount += (long)Long.bitCount(arr1[i] ^ arr2[i]);
        }
        return popCount;
    }

    public static int nextHighestPowerOfTwo(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public static long nextHighestPowerOfTwo(long v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        v |= v >> 32;
        return ++v;
    }

    public static long interleave(int even, int odd) {
        long v1 = 0xFFFFFFFFL & (long)even;
        long v2 = 0xFFFFFFFFL & (long)odd;
        v1 = (v1 | v1 << SHIFT[4]) & MAGIC[4];
        v1 = (v1 | v1 << SHIFT[3]) & MAGIC[3];
        v1 = (v1 | v1 << SHIFT[2]) & MAGIC[2];
        v1 = (v1 | v1 << SHIFT[1]) & MAGIC[1];
        v1 = (v1 | v1 << SHIFT[0]) & MAGIC[0];
        v2 = (v2 | v2 << SHIFT[4]) & MAGIC[4];
        v2 = (v2 | v2 << SHIFT[3]) & MAGIC[3];
        v2 = (v2 | v2 << SHIFT[2]) & MAGIC[2];
        v2 = (v2 | v2 << SHIFT[1]) & MAGIC[1];
        v2 = (v2 | v2 << SHIFT[0]) & MAGIC[0];
        return v2 << 1 | v1;
    }

    public static long deinterleave(long b) {
        b &= MAGIC[0];
        b = (b ^ b >>> SHIFT[0]) & MAGIC[1];
        b = (b ^ b >>> SHIFT[1]) & MAGIC[2];
        b = (b ^ b >>> SHIFT[2]) & MAGIC[3];
        b = (b ^ b >>> SHIFT[3]) & MAGIC[4];
        b = (b ^ b >>> SHIFT[4]) & MAGIC[5];
        return b;
    }

    public static final long flipFlop(long b) {
        return (b & MAGIC[6]) >>> 1 | (b & MAGIC[0]) << 1;
    }

    public static int zigZagEncode(int i) {
        return i >> 31 ^ i << 1;
    }

    public static long zigZagEncode(long l) {
        return l >> 63 ^ l << 1;
    }

    public static int zigZagDecode(int i) {
        return i >>> 1 ^ -(i & 1);
    }

    public static long zigZagDecode(long l) {
        return l >>> 1 ^ -(l & 1L);
    }
}

