/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store;

import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.BaseDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.FSLockFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.LockFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.MMapDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.NIOFSDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.SimpleFSDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Constants;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;

public abstract class FSDirectory
extends BaseDirectory {
    protected final Path directory;
    private final Set<String> pendingDeletes = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger opsSinceLastDelete = new AtomicInteger();
    private final AtomicLong nextTempFileCounter = new AtomicLong();

    protected FSDirectory(Path path, LockFactory lockFactory) throws IOException {
        super(lockFactory);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        this.directory = path.toRealPath(new LinkOption[0]);
    }

    public static FSDirectory open(Path path) throws IOException {
        return FSDirectory.open(path, FSLockFactory.getDefault());
    }

    public static FSDirectory open(Path path, LockFactory lockFactory) throws IOException {
        if (Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            return new MMapDirectory(path, lockFactory);
        }
        if (Constants.WINDOWS) {
            return new SimpleFSDirectory(path, lockFactory);
        }
        return new NIOFSDirectory(path, lockFactory);
    }

    public static String[] listAll(Path dir) throws IOException {
        return FSDirectory.listAll(dir, null);
    }

    private static String[] listAll(Path dir, Set<String> skipNames) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                String name = path.getFileName().toString();
                if (skipNames != null && skipNames.contains(name)) continue;
                entries.add(name);
            }
        }
        Object[] array = entries.toArray(new String[entries.size()]);
        Arrays.sort(array);
        return array;
    }

    @Override
    public String[] listAll() throws IOException {
        this.ensureOpen();
        return FSDirectory.listAll(this.directory, this.pendingDeletes);
    }

    @Override
    public long fileLength(String name) throws IOException {
        this.ensureOpen();
        if (this.pendingDeletes.contains(name)) {
            throw new NoSuchFileException("file \"" + name + "\" is pending delete");
        }
        return Files.size(this.directory.resolve(name));
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        this.maybeDeletePendingFiles();
        if (this.pendingDeletes.remove(name)) {
            this.privateDeleteFile(name, true);
            this.pendingDeletes.remove(name);
        }
        return new FSIndexOutput(name);
    }

    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        this.ensureOpen();
        this.maybeDeletePendingFiles();
        while (true) {
            try {
                String name;
                while (this.pendingDeletes.contains(name = IndexFileNames.segmentFileName(prefix, suffix + "_" + Long.toString(this.nextTempFileCounter.getAndIncrement(), 36), "tmp"))) {
                }
                return new FSIndexOutput(name, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    protected void ensureCanRead(String name) throws IOException {
        if (this.pendingDeletes.contains(name)) {
            throw new NoSuchFileException("file \"" + name + "\" is pending delete and cannot be opened for read");
        }
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.ensureOpen();
        for (String name : names) {
            this.fsync(name);
        }
        this.maybeDeletePendingFiles();
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.ensureOpen();
        if (this.pendingDeletes.contains(source)) {
            throw new NoSuchFileException("file \"" + source + "\" is pending delete and cannot be moved");
        }
        this.maybeDeletePendingFiles();
        if (this.pendingDeletes.remove(dest)) {
            this.privateDeleteFile(dest, true);
            this.pendingDeletes.remove(dest);
        }
        Files.move(this.directory.resolve(source), this.directory.resolve(dest), StandardCopyOption.ATOMIC_MOVE);
    }

    @Override
    public void syncMetaData() throws IOException {
        this.ensureOpen();
        IOUtils.fsync(this.directory, true);
        this.maybeDeletePendingFiles();
    }

    @Override
    public synchronized void close() throws IOException {
        this.isOpen = false;
        this.deletePendingFiles();
    }

    public Path getDirectory() {
        this.ensureOpen();
        return this.directory;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.directory + " lockFactory=" + this.lockFactory;
    }

    protected void fsync(String name) throws IOException {
        IOUtils.fsync(this.directory.resolve(name), false);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        if (this.pendingDeletes.contains(name)) {
            throw new NoSuchFileException("file \"" + name + "\" is already pending delete");
        }
        this.privateDeleteFile(name, false);
        this.maybeDeletePendingFiles();
    }

    public synchronized void deletePendingFiles() throws IOException {
        if (!this.pendingDeletes.isEmpty()) {
            for (String name : new HashSet<String>(this.pendingDeletes)) {
                this.privateDeleteFile(name, true);
            }
        }
    }

    private void maybeDeletePendingFiles() throws IOException {
        int count;
        if (!this.pendingDeletes.isEmpty() && (count = this.opsSinceLastDelete.incrementAndGet()) >= this.pendingDeletes.size()) {
            this.opsSinceLastDelete.addAndGet(-count);
            this.deletePendingFiles();
        }
    }

    private void privateDeleteFile(String name, boolean isPendingDelete) throws IOException {
        try {
            Files.delete(this.directory.resolve(name));
            this.pendingDeletes.remove(name);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.pendingDeletes.remove(name);
            if (!isPendingDelete || !Constants.WINDOWS) {
                throw e;
            }
        }
        catch (IOException ioe) {
            this.pendingDeletes.add(name);
        }
    }

    @Override
    public synchronized Set<String> getPendingDeletions() throws IOException {
        this.deletePendingFiles();
        if (this.pendingDeletes.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(this.pendingDeletes));
    }

    final class FSIndexOutput
    extends OutputStreamIndexOutput {
        static final int CHUNK_SIZE = 8192;

        public FSIndexOutput(String name) throws IOException {
            this(name, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        }

        FSIndexOutput(String name, OpenOption ... options) throws IOException {
            super("FSIndexOutput(path=\"" + FSDirectory.this.directory.resolve(name) + "\")", name, new FilterOutputStream(Files.newOutputStream(FSDirectory.this.directory.resolve(name), options)){

                @Override
                public void write(byte[] b, int offset, int length) throws IOException {
                    while (length > 0) {
                        int chunk = Math.min(length, 8192);
                        this.out.write(b, offset, chunk);
                        length -= chunk;
                        offset += chunk;
                    }
                }
            }, 8192);
        }
    }
}

