/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoBaseCircle;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Membership;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Plane;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Vector;

class GeoExactCircle
extends GeoBaseCircle {
    protected final GeoPoint center;
    protected final double radius;
    protected final double actualAccuracy;
    protected final GeoPoint[] edgePoints;
    protected final List<CircleSlice> circleSlices;

    public GeoExactCircle(PlanetModel planetModel, double lat, double lon, double radius, double accuracy) {
        super(planetModel);
        GeoPoint edgePoint;
        if (lat < -1.5707963267948966 || lat > 1.5707963267948966) {
            throw new IllegalArgumentException("Latitude out of bounds");
        }
        if (lon < -Math.PI || lon > Math.PI) {
            throw new IllegalArgumentException("Longitude out of bounds");
        }
        if (radius < 0.0) {
            throw new IllegalArgumentException("Radius out of bounds");
        }
        if (radius < 1.0E-12) {
            throw new IllegalArgumentException("Radius cannot be effectively zero");
        }
        if (planetModel.minimumPoleDistance - radius < 1.0E-12) {
            throw new IllegalArgumentException("Radius out of bounds. It cannot be bigger than " + planetModel.minimumPoleDistance + " for this planet model");
        }
        this.center = new GeoPoint(planetModel, lat, lon);
        this.radius = radius;
        this.actualAccuracy = accuracy < 1.0E-12 ? 1.0E-12 : accuracy;
        ArrayList<ApproximationSlice> slices = new ArrayList<ApproximationSlice>(100);
        GeoPoint northPoint = planetModel.surfacePointOnBearing(this.center, radius, 0.0);
        GeoPoint southPoint = planetModel.surfacePointOnBearing(this.center, radius, Math.PI);
        GeoPoint eastPoint = planetModel.surfacePointOnBearing(this.center, radius, 1.5707963267948966);
        GeoPoint westPoint = planetModel.surfacePointOnBearing(this.center, radius, 4.71238898038469);
        if (planetModel.c > planetModel.ab) {
            slices.add(new ApproximationSlice(this.center, eastPoint, 1.5707963267948966, westPoint, -1.5707963267948966, northPoint, 0.0, true));
            slices.add(new ApproximationSlice(this.center, westPoint, 4.71238898038469, eastPoint, 1.5707963267948966, southPoint, Math.PI, true));
            edgePoint = eastPoint;
        } else {
            slices.add(new ApproximationSlice(this.center, northPoint, 0.0, southPoint, Math.PI, eastPoint, 1.5707963267948966, true));
            slices.add(new ApproximationSlice(this.center, southPoint, Math.PI, northPoint, Math.PI * 2, westPoint, 4.71238898038469, true));
            edgePoint = northPoint;
        }
        this.circleSlices = new ArrayList<CircleSlice>();
        while (slices.size() > 0) {
            ApproximationSlice thisSlice = (ApproximationSlice)slices.remove(slices.size() - 1);
            double interpPoint1Bearing = (thisSlice.point1Bearing + thisSlice.middlePointBearing) * 0.5;
            GeoPoint interpPoint1 = planetModel.surfacePointOnBearing(this.center, radius, interpPoint1Bearing);
            double interpPoint2Bearing = (thisSlice.point2Bearing + thisSlice.middlePointBearing) * 0.5;
            GeoPoint interpPoint2 = planetModel.surfacePointOnBearing(this.center, radius, interpPoint2Bearing);
            if (!thisSlice.mustSplit && Math.abs(thisSlice.plane.evaluate(interpPoint1)) < this.actualAccuracy && Math.abs(thisSlice.plane.evaluate(interpPoint2)) < this.actualAccuracy) {
                this.circleSlices.add(new CircleSlice(thisSlice.plane, thisSlice.endPoint1, thisSlice.endPoint2, this.center, thisSlice.middlePoint));
                continue;
            }
            slices.add(new ApproximationSlice(this.center, thisSlice.endPoint1, thisSlice.point1Bearing, thisSlice.middlePoint, thisSlice.middlePointBearing, interpPoint1, interpPoint1Bearing, false));
            slices.add(new ApproximationSlice(this.center, thisSlice.middlePoint, thisSlice.middlePointBearing, thisSlice.endPoint2, thisSlice.point2Bearing, interpPoint2, interpPoint2Bearing, false));
        }
        this.edgePoints = new GeoPoint[]{edgePoint};
    }

    public GeoExactCircle(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.center.getLatitude());
        SerializableObject.writeDouble(outputStream, this.center.getLongitude());
        SerializableObject.writeDouble(outputStream, this.radius);
        SerializableObject.writeDouble(outputStream, this.actualAccuracy);
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public GeoPoint getCenter() {
        return this.center;
    }

    @Override
    protected double distance(DistanceStyle distanceStyle, double x, double y, double z) {
        return distanceStyle.computeDistance(this.center, x, y, z);
    }

    @Override
    protected void distanceBounds(Bounds bounds, DistanceStyle distanceStyle, double distanceValue) {
        this.getBounds(bounds);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double outsideDistance = Double.POSITIVE_INFINITY;
        for (CircleSlice slice : this.circleSlices) {
            Membership[] membershipArray = new Membership[]{slice.plane1, slice.plane2};
            double distance = distanceStyle.computeDistance(this.planetModel, (Plane)slice.circlePlane, x, y, z, membershipArray);
            if (!(distance < outsideDistance)) continue;
            outsideDistance = distance;
        }
        return outsideDistance;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (CircleSlice slice : this.circleSlices) {
            if (!slice.circlePlane.isWithin(x, y, z) || !slice.plane1.isWithin(x, y, z) || !slice.plane2.isWithin(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        for (CircleSlice slice : this.circleSlices) {
            if (!slice.circlePlane.intersects(this.planetModel, p, notablePoints, slice.notableEdgePoints, bounds, slice.plane1, slice.plane2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        for (CircleSlice slice : this.circleSlices) {
            if (!geoShape.intersects(slice.circlePlane, slice.notableEdgePoints, slice.plane1, slice.plane2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addPoint(this.center);
        for (CircleSlice slice : this.circleSlices) {
            bounds.addPlane(this.planetModel, slice.circlePlane, slice.plane1, slice.plane2);
            for (GeoPoint point : slice.notableEdgePoints) {
                bounds.addPoint(point);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoExactCircle)) {
            return false;
        }
        GeoExactCircle other = (GeoExactCircle)o;
        return super.equals(other) && other.center.equals(this.center) && other.radius == this.radius && other.actualAccuracy == this.actualAccuracy;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.center.hashCode();
        long temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.actualAccuracy);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoExactCircle: {planetmodel=" + this.planetModel + ", center=" + this.center + ", radius=" + this.radius + "(" + this.radius * 180.0 / Math.PI + "), accuracy=" + this.actualAccuracy + "}";
    }

    protected static class CircleSlice {
        final GeoPoint[] notableEdgePoints;
        public final SidedPlane circlePlane;
        public final SidedPlane plane1;
        public final SidedPlane plane2;

        public CircleSlice(SidedPlane circlePlane, GeoPoint endPoint1, GeoPoint endPoint2, GeoPoint center, GeoPoint check) {
            this.circlePlane = circlePlane;
            this.plane1 = new SidedPlane((Vector)check, (Vector)endPoint1, center);
            this.plane2 = new SidedPlane((Vector)check, (Vector)endPoint2, center);
            this.notableEdgePoints = new GeoPoint[]{endPoint1, endPoint2};
        }

        public String toString() {
            return "{circle plane = " + this.circlePlane + " plane 1 = " + this.plane1 + " plane 2 = " + this.plane2 + " notable edge points = " + this.notableEdgePoints + "}";
        }
    }

    protected static class ApproximationSlice {
        public final SidedPlane plane;
        public final GeoPoint endPoint1;
        public final double point1Bearing;
        public final GeoPoint endPoint2;
        public final double point2Bearing;
        public final GeoPoint middlePoint;
        public final double middlePointBearing;
        public final boolean mustSplit;

        public ApproximationSlice(GeoPoint center, GeoPoint endPoint1, double point1Bearing, GeoPoint endPoint2, double point2Bearing, GeoPoint middlePoint, double middlePointBearing, boolean mustSplit) {
            this.endPoint1 = endPoint1;
            this.point1Bearing = point1Bearing;
            this.endPoint2 = endPoint2;
            this.point2Bearing = point2Bearing;
            this.middlePoint = middlePoint;
            this.middlePointBearing = middlePointBearing;
            this.mustSplit = mustSplit;
            this.plane = SidedPlane.constructNormalizedThreePointSidedPlane(center, endPoint1, endPoint2, middlePoint);
            if (this.plane == null) {
                throw new IllegalArgumentException("Either circle is too small or accuracy is too high; could not construct a plane with endPoint1=" + endPoint1 + " bearing " + point1Bearing + ", endPoint2=" + endPoint2 + " bearing " + point2Bearing + ", middle=" + middlePoint + " bearing " + middlePointBearing);
            }
            if (this.plane.isWithin(-center.x, -center.y, -center.z)) {
                throw new IllegalArgumentException("Could not construct a valid plane for this planet model with endPoint1=" + endPoint1 + " bearing " + point1Bearing + ", endPoint2=" + endPoint2 + " bearing " + point2Bearing + ", middle=" + middlePoint + " bearing " + middlePointBearing);
            }
        }

        public String toString() {
            return "{end point 1 = " + this.endPoint1 + " bearing 1 = " + this.point1Bearing + " end point 2 = " + this.endPoint2 + " bearing 2 = " + this.point2Bearing + " middle point = " + this.middlePoint + " middle bearing = " + this.middlePointBearing + "}";
        }
    }
}

