/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.prefix.tree;

import java.util.Arrays;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.prefix.tree.FilterCellIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.prefix.tree.LegacyCell;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

abstract class LegacyPrefixTree
extends SpatialPrefixTree {
    public LegacyPrefixTree(SpatialContext ctx, int maxLevels) {
        super(ctx, maxLevels);
    }

    @Override
    public double getDistanceForLevel(int level) {
        if (level < 1 || level > this.getMaxLevels()) {
            throw new IllegalArgumentException("Level must be in 1 to maxLevels range");
        }
        Cell cell = this.getCell(this.ctx.getWorldBounds().getCenter(), level);
        Rectangle bbox = cell.getShape().getBoundingBox();
        double width = bbox.getWidth();
        double height = bbox.getHeight();
        return Math.sqrt(width * width + height * height);
    }

    protected abstract Cell getCell(Point var1, int var2);

    @Override
    public Cell readCell(BytesRef term, Cell scratch) {
        LegacyCell cell = (LegacyCell)scratch;
        if (cell == null) {
            cell = (LegacyCell)this.getWorldCell();
        }
        cell.readCell(term);
        return cell;
    }

    @Override
    public CellIterator getTreeCellIterator(Shape shape, int detailLevel) {
        if (!(shape instanceof Point)) {
            return super.getTreeCellIterator(shape, detailLevel);
        }
        Cell cell = this.getCell((Point)shape, detailLevel);
        assert (cell instanceof LegacyCell);
        BytesRef fullBytes = cell.getTokenBytesNoLeaf(null);
        Cell[] cells = new Cell[detailLevel];
        for (int i = 1; i < detailLevel; ++i) {
            Cell parentCell;
            fullBytes.length = i;
            cells[i - 1] = parentCell = this.readCell(fullBytes, null);
        }
        cells[detailLevel - 1] = cell;
        return new FilterCellIterator(Arrays.asList(cells).iterator(), null);
    }
}

