/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.tst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.InputIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.Lookup;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.SortedInputIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.tst.TSTAutocomplete;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.tst.TernaryTreeNode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.DataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.DataOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.CharsRefBuilder;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RamUsageEstimator;

public class TSTLookup
extends Lookup {
    TernaryTreeNode root = new TernaryTreeNode();
    TSTAutocomplete autocomplete = new TSTAutocomplete();
    private long count = 0L;
    private final Directory tempDir;
    private final String tempFileNamePrefix;
    private static final Comparator<BytesRef> utf8SortedAsUTF16SortOrder = (a, b) -> {
        byte[] aBytes = a.bytes;
        int aUpto = a.offset;
        byte[] bBytes = b.bytes;
        int bUpto = b.offset;
        int aStop = aUpto + Math.min(a.length, b.length);
        while (aUpto < aStop) {
            int bByte;
            int aByte;
            if ((aByte = aBytes[aUpto++] & 0xFF) == (bByte = bBytes[bUpto++] & 0xFF)) continue;
            if (aByte >= 238 && bByte >= 238) {
                if ((aByte & 0xFE) == 238) {
                    aByte += 14;
                }
                if ((bByte & 0xFE) == 238) {
                    bByte += 14;
                }
            }
            return aByte - bByte;
        }
        return a.length - b.length;
    };
    private static final byte LO_KID = 1;
    private static final byte EQ_KID = 2;
    private static final byte HI_KID = 4;
    private static final byte HAS_TOKEN = 8;
    private static final byte HAS_VALUE = 16;

    public TSTLookup() {
        this(null, null);
    }

    public TSTLookup(Directory tempDir, String tempFileNamePrefix) {
        this.tempDir = tempDir;
        this.tempFileNamePrefix = tempFileNamePrefix;
    }

    @Override
    public void build(InputIterator iterator) throws IOException {
        BytesRef spare;
        if (iterator.hasPayloads()) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        if (iterator.hasContexts()) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        this.root = new TernaryTreeNode();
        iterator = new SortedInputIterator(this.tempDir, this.tempFileNamePrefix, iterator, utf8SortedAsUTF16SortOrder);
        this.count = 0L;
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<Long> vals = new ArrayList<Long>();
        CharsRefBuilder charsSpare = new CharsRefBuilder();
        while ((spare = iterator.next()) != null) {
            charsSpare.copyUTF8Bytes(spare);
            tokens.add(charsSpare.toString());
            vals.add(iterator.weight());
            ++this.count;
        }
        this.autocomplete.balancedTree(tokens.toArray(), vals.toArray(), 0, tokens.size() - 1, this.root);
    }

    public boolean add(CharSequence key, Object value) {
        this.autocomplete.insert(this.root, key, value, 0);
        return true;
    }

    public Object get(CharSequence key) {
        ArrayList<TernaryTreeNode> list = this.autocomplete.prefixCompletion(this.root, key, 0);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (TernaryTreeNode n : list) {
            if (!TSTLookup.charSeqEquals(n.token, key)) continue;
            return n.val;
        }
        return null;
    }

    private static boolean charSeqEquals(CharSequence left, CharSequence right) {
        int len = left.length();
        if (len != right.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (left.charAt(i) == right.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) {
        if (contexts != null) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        ArrayList<TernaryTreeNode> list = this.autocomplete.prefixCompletion(this.root, key, 0);
        ArrayList<Lookup.LookupResult> res = new ArrayList<Lookup.LookupResult>();
        if (list == null || list.size() == 0) {
            return res;
        }
        int maxCnt = Math.min(num, list.size());
        if (onlyMorePopular) {
            Lookup.LookupPriorityQueue queue = new Lookup.LookupPriorityQueue(num);
            for (TernaryTreeNode ttn : list) {
                queue.insertWithOverflow(new Lookup.LookupResult(ttn.token, ((Number)ttn.val).longValue()));
            }
            for (Lookup.LookupResult lr : queue.getResults()) {
                res.add(lr);
            }
        } else {
            for (int i = 0; i < maxCnt; ++i) {
                TernaryTreeNode ttn = (TernaryTreeNode)list.get(i);
                res.add(new Lookup.LookupResult(ttn.token, ((Number)ttn.val).longValue()));
            }
        }
        return res;
    }

    private void readRecursively(DataInput in, TernaryTreeNode node) throws IOException {
        node.splitchar = in.readString().charAt(0);
        byte mask = in.readByte();
        if ((mask & 8) != 0) {
            node.token = in.readString();
        }
        if ((mask & 0x10) != 0) {
            node.val = in.readLong();
        }
        if ((mask & 1) != 0) {
            node.loKid = new TernaryTreeNode();
            this.readRecursively(in, node.loKid);
        }
        if ((mask & 2) != 0) {
            node.eqKid = new TernaryTreeNode();
            this.readRecursively(in, node.eqKid);
        }
        if ((mask & 4) != 0) {
            node.hiKid = new TernaryTreeNode();
            this.readRecursively(in, node.hiKid);
        }
    }

    private void writeRecursively(DataOutput out, TernaryTreeNode node) throws IOException {
        out.writeString(new String(new char[]{node.splitchar}, 0, 1));
        byte mask = 0;
        if (node.eqKid != null) {
            mask = (byte)(mask | 2);
        }
        if (node.loKid != null) {
            mask = (byte)(mask | 1);
        }
        if (node.hiKid != null) {
            mask = (byte)(mask | 4);
        }
        if (node.token != null) {
            mask = (byte)(mask | 8);
        }
        if (node.val != null) {
            mask = (byte)(mask | 0x10);
        }
        out.writeByte(mask);
        if (node.token != null) {
            out.writeString(node.token);
        }
        if (node.val != null) {
            out.writeLong(((Number)node.val).longValue());
        }
        if (node.loKid != null) {
            this.writeRecursively(out, node.loKid);
        }
        if (node.eqKid != null) {
            this.writeRecursively(out, node.eqKid);
        }
        if (node.hiKid != null) {
            this.writeRecursively(out, node.hiKid);
        }
    }

    @Override
    public synchronized boolean store(DataOutput output) throws IOException {
        output.writeVLong(this.count);
        this.writeRecursively(output, this.root);
        return true;
    }

    @Override
    public synchronized boolean load(DataInput input) throws IOException {
        this.count = input.readVLong();
        this.root = new TernaryTreeNode();
        this.readRecursively(input, this.root);
        return true;
    }

    @Override
    public long ramBytesUsed() {
        long mem = RamUsageEstimator.shallowSizeOf(this);
        if (this.root != null) {
            mem += this.root.sizeInBytes();
        }
        return mem;
    }

    @Override
    public long getCount() {
        return this.count;
    }
}

