/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchesIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryVisitor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.TermIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;

class PayloadFilteredTermIntervalsSource
extends IntervalsSource {
    final BytesRef term;
    final Predicate<BytesRef> filter;

    PayloadFilteredTermIntervalsSource(BytesRef term, Predicate<BytesRef> filter) {
        this.term = term;
        this.filter = filter;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        Terms terms = ctx.reader().terms(field);
        if (terms == null) {
            return null;
        }
        if (!terms.hasPositions()) {
            throw new IllegalArgumentException("Cannot create an IntervalIterator over field " + field + " because it has no indexed positions");
        }
        if (!terms.hasPayloads()) {
            throw new IllegalArgumentException("Cannot create a payload-filtered iterator over field " + field + " because it has no indexed payloads");
        }
        TermsEnum te = terms.iterator();
        if (!te.seekExact(this.term)) {
            return null;
        }
        return this.intervals(te);
    }

    private IntervalIterator intervals(TermsEnum te) throws IOException {
        final PostingsEnum pe = te.postings(null, 88);
        final float cost = TermIntervalsSource.termPositionsCost(te);
        return new IntervalIterator(){
            int pos = -1;
            int upto;

            @Override
            public int docID() {
                return pe.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                int doc = pe.nextDoc();
                this.reset();
                return doc;
            }

            @Override
            public int advance(int target) throws IOException {
                int doc = pe.advance(target);
                this.reset();
                return doc;
            }

            @Override
            public long cost() {
                return pe.cost();
            }

            @Override
            public int start() {
                return this.pos;
            }

            @Override
            public int end() {
                return this.pos;
            }

            @Override
            public int gaps() {
                return 0;
            }

            @Override
            public int nextInterval() throws IOException {
                do {
                    if (this.upto <= 0) {
                        this.pos = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    --this.upto;
                    this.pos = pe.nextPosition();
                } while (!PayloadFilteredTermIntervalsSource.this.filter.test(pe.getPayload()));
                return this.pos;
            }

            @Override
            public float matchCost() {
                return cost;
            }

            private void reset() throws IOException {
                if (pe.docID() == Integer.MAX_VALUE) {
                    this.upto = -1;
                    this.pos = Integer.MAX_VALUE;
                } else {
                    this.upto = pe.freq();
                    this.pos = -1;
                }
            }

            @Override
            public String toString() {
                return PayloadFilteredTermIntervalsSource.this.term.utf8ToString() + ":" + super.toString();
            }
        };
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        Terms terms = ctx.reader().terms(field);
        if (terms == null) {
            return null;
        }
        if (!terms.hasPositions()) {
            throw new IllegalArgumentException("Cannot create an IntervalIterator over field " + field + " because it has no indexed positions");
        }
        if (!terms.hasPayloads()) {
            throw new IllegalArgumentException("Cannot create a payload-filtered iterator over field " + field + " because it has no indexed payloads");
        }
        TermsEnum te = terms.iterator();
        if (!te.seekExact(this.term)) {
            return null;
        }
        return this.matches(te, doc);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        visitor.consumeTerms(new IntervalQuery(field, this), new Term(field, this.term));
    }

    private MatchesIterator matches(TermsEnum te, int doc) throws IOException {
        final PostingsEnum pe = te.postings(null, 120);
        if (pe.advance(doc) != doc) {
            return null;
        }
        return new MatchesIterator(){
            int upto;
            int pos;
            {
                this.upto = pe.freq();
                this.pos = -1;
            }

            @Override
            public boolean next() throws IOException {
                do {
                    if (this.upto <= 0) {
                        this.pos = Integer.MAX_VALUE;
                        return false;
                    }
                    --this.upto;
                    this.pos = pe.nextPosition();
                } while (!PayloadFilteredTermIntervalsSource.this.filter.test(pe.getPayload()));
                return true;
            }

            @Override
            public int startPosition() {
                return this.pos;
            }

            @Override
            public int endPosition() {
                return this.pos;
            }

            @Override
            public int startOffset() throws IOException {
                return pe.startOffset();
            }

            @Override
            public int endOffset() throws IOException {
                return pe.endOffset();
            }

            @Override
            public MatchesIterator getSubMatches() {
                return null;
            }

            @Override
            public Query getQuery() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int minExtent() {
        return 1;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singleton(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.term);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermIntervalsSource that = (TermIntervalsSource)o;
        return Objects.equals(this.term, that.term);
    }

    @Override
    public String toString() {
        return "PAYLOAD_FILTERED(" + this.term.utf8ToString() + ")";
    }
}

