/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.ConjunctionIntervalIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.ConjunctionIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.Disjunctions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalsSource;

class OrderedIntervalsSource
extends ConjunctionIntervalsSource {
    static IntervalsSource build(List<IntervalsSource> sources) {
        if (sources.size() == 1) {
            return sources.get(0);
        }
        return new OrderedIntervalsSource(OrderedIntervalsSource.flatten(sources));
    }

    private static List<IntervalsSource> flatten(List<IntervalsSource> sources) {
        ArrayList<IntervalsSource> flattened = new ArrayList<IntervalsSource>();
        for (IntervalsSource s : sources) {
            if (s instanceof OrderedIntervalsSource) {
                flattened.addAll(((OrderedIntervalsSource)s).subSources);
                continue;
            }
            flattened.add(s);
        }
        return flattened;
    }

    private OrderedIntervalsSource(List<IntervalsSource> sources) {
        super(sources, true);
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators) {
        return new OrderedIntervalIterator(iterators);
    }

    @Override
    public int minExtent() {
        int minExtent = 0;
        for (IntervalsSource subSource : this.subSources) {
            minExtent += subSource.minExtent();
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Disjunctions.pullUp(this.subSources, OrderedIntervalsSource::new);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.subSources);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OrderedIntervalsSource)) {
            return false;
        }
        OrderedIntervalsSource s = (OrderedIntervalsSource)other;
        return Objects.equals(this.subSources, s.subSources);
    }

    @Override
    public String toString() {
        return "ORDERED(" + this.subSources.stream().map(IntervalsSource::toString).collect(Collectors.joining(",")) + ")";
    }

    private static class OrderedIntervalIterator
    extends ConjunctionIntervalIterator {
        int start = -1;
        int end = -1;
        int i;
        int firstEnd;

        private OrderedIntervalIterator(List<IntervalIterator> subIntervals) {
            super(subIntervals);
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int nextInterval() throws IOException {
            this.end = Integer.MAX_VALUE;
            this.start = Integer.MAX_VALUE;
            int b = Integer.MAX_VALUE;
            this.i = 1;
            while (true) {
                if (((IntervalIterator)this.subIterators.get(this.i - 1)).end() >= b) {
                    return this.start;
                }
                if (this.i != this.subIterators.size() && ((IntervalIterator)this.subIterators.get(this.i)).start() <= ((IntervalIterator)this.subIterators.get(this.i - 1)).end()) {
                    do {
                        if (((IntervalIterator)this.subIterators.get(this.i)).end() < b && ((IntervalIterator)this.subIterators.get(this.i)).nextInterval() != Integer.MAX_VALUE) continue;
                        return this.start;
                    } while (((IntervalIterator)this.subIterators.get(this.i)).start() <= ((IntervalIterator)this.subIterators.get(this.i - 1)).end());
                    ++this.i;
                    continue;
                }
                this.start = ((IntervalIterator)this.subIterators.get(0)).start();
                if (this.start == Integer.MAX_VALUE) {
                    this.end = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.firstEnd = ((IntervalIterator)this.subIterators.get(0)).end();
                this.end = ((IntervalIterator)this.subIterators.get(this.subIterators.size() - 1)).end();
                b = ((IntervalIterator)this.subIterators.get(this.subIterators.size() - 1)).start();
                this.i = 1;
                if (((IntervalIterator)this.subIterators.get(0)).nextInterval() == Integer.MAX_VALUE) break;
            }
            return this.start;
        }

        @Override
        public int gaps() {
            int gaps = ((IntervalIterator)this.subIterators.get(1)).start() - this.firstEnd - 1;
            for (int i = 2; i < this.subIterators.size(); ++i) {
                gaps += ((IntervalIterator)this.subIterators.get(i)).start() - ((IntervalIterator)this.subIterators.get(i - 1)).end() - 1;
            }
            return gaps;
        }

        @Override
        protected void reset() throws IOException {
            ((IntervalIterator)this.subIterators.get(0)).nextInterval();
            this.i = 1;
            this.firstEnd = -1;
            this.end = -1;
            this.start = -1;
        }
    }
}

