/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchesIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchesUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryVisitor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.DisjunctionIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.TermIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.CompiledAutomaton;

class MultiTermIntervalsSource
extends IntervalsSource {
    private final CompiledAutomaton automaton;
    private final int maxExpansions;
    private final String pattern;

    MultiTermIntervalsSource(CompiledAutomaton automaton, int maxExpansions, String pattern) {
        this.automaton = automaton;
        this.maxExpansions = maxExpansions;
        this.pattern = pattern;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        BytesRef term;
        Terms terms = ctx.reader().terms(field);
        if (terms == null) {
            return null;
        }
        ArrayList<IntervalIterator> subSources = new ArrayList<IntervalIterator>();
        TermsEnum te = this.automaton.getTermsEnum(terms);
        int count = 0;
        while ((term = te.next()) != null) {
            subSources.add(TermIntervalsSource.intervals(term, te));
            if (count++ <= this.maxExpansions) continue;
            throw new IllegalStateException("Automaton " + this.pattern + " expanded to too many terms (limit " + this.maxExpansions + ")");
        }
        if (subSources.size() == 0) {
            return null;
        }
        return new DisjunctionIntervalsSource.DisjunctionIntervalIterator(subSources);
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        BytesRef term;
        Terms terms = ctx.reader().terms(field);
        if (terms == null) {
            return null;
        }
        ArrayList<MatchesIterator> subMatches = new ArrayList<MatchesIterator>();
        TermsEnum te = this.automaton.getTermsEnum(terms);
        int count = 0;
        while ((term = te.next()) != null) {
            MatchesIterator mi = TermIntervalsSource.matches(te, doc);
            if (mi == null) continue;
            subMatches.add(mi);
            if (count++ <= this.maxExpansions) continue;
            throw new IllegalStateException("Automaton " + term + " expanded to too many terms (limit " + this.maxExpansions + ")");
        }
        return MatchesUtils.disjunction(subMatches);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
    }

    @Override
    public int minExtent() {
        return 1;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singleton(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTermIntervalsSource that = (MultiTermIntervalsSource)o;
        return this.maxExpansions == that.maxExpansions && Objects.equals(this.automaton, that.automaton) && Objects.equals(this.pattern, that.pattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.automaton, this.maxExpansions, this.pattern);
    }

    @Override
    public String toString() {
        return "MultiTerm(" + this.pattern + ")";
    }
}

