/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.PrefixQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.WildcardQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.BlockIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.ContainedByIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.ContainingIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.DisjunctionIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.ExtendedIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.FilteredIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.FixedFieldIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.MinimumShouldMatchIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.MultiTermIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.NoRewriteDisjunctionIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.NonOverlappingIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.NotContainedByIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.NotContainingIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.OffsetIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.OrderedIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.OverlappingIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.PayloadFilteredTermIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.TermIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.UnorderedIntervalsSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.CompiledAutomaton;

public final class Intervals {
    private Intervals() {
    }

    public static IntervalsSource term(BytesRef term) {
        return new TermIntervalsSource(term);
    }

    public static IntervalsSource term(String term) {
        return new TermIntervalsSource(new BytesRef(term));
    }

    public static IntervalsSource term(String term, Predicate<BytesRef> payloadFilter) {
        return Intervals.term(new BytesRef(term), payloadFilter);
    }

    public static IntervalsSource term(BytesRef term, Predicate<BytesRef> payloadFilter) {
        return new PayloadFilteredTermIntervalsSource(term, payloadFilter);
    }

    public static IntervalsSource phrase(String ... terms) {
        if (terms.length == 1) {
            return Intervals.term(terms[0]);
        }
        IntervalsSource[] sources = new IntervalsSource[terms.length];
        int i = 0;
        for (String term : terms) {
            sources[i] = Intervals.term(term);
            ++i;
        }
        return Intervals.phrase(sources);
    }

    public static IntervalsSource phrase(IntervalsSource ... subSources) {
        return BlockIntervalsSource.build(Arrays.asList(subSources));
    }

    public static IntervalsSource or(IntervalsSource ... subSources) {
        return Intervals.or(true, Arrays.asList(subSources));
    }

    public static IntervalsSource or(boolean rewrite, IntervalsSource ... subSources) {
        return Intervals.or(rewrite, Arrays.asList(subSources));
    }

    public static IntervalsSource or(List<IntervalsSource> subSources) {
        return Intervals.or(true, subSources);
    }

    public static IntervalsSource or(boolean rewrite, List<IntervalsSource> subSources) {
        if (subSources.size() == 1) {
            return subSources.get(0);
        }
        if (rewrite) {
            return new DisjunctionIntervalsSource(subSources);
        }
        return new NoRewriteDisjunctionIntervalsSource(subSources);
    }

    public static IntervalsSource prefix(String prefix) {
        CompiledAutomaton ca = new CompiledAutomaton(PrefixQuery.toAutomaton(new BytesRef(prefix)));
        return new MultiTermIntervalsSource(ca, 128, prefix);
    }

    public static IntervalsSource wildcard(String wildcard) {
        CompiledAutomaton ca = new CompiledAutomaton(WildcardQuery.toAutomaton(new Term("", wildcard)));
        return new MultiTermIntervalsSource(ca, 128, wildcard);
    }

    public static IntervalsSource maxwidth(int width, IntervalsSource subSource) {
        return FilteredIntervalsSource.maxWidth(subSource, width);
    }

    public static IntervalsSource maxgaps(int gaps, IntervalsSource subSource) {
        return FilteredIntervalsSource.maxGaps(subSource, gaps);
    }

    public static IntervalsSource extend(IntervalsSource source, int before, int after) {
        return new ExtendedIntervalsSource(source, before, after);
    }

    public static IntervalsSource ordered(IntervalsSource ... subSources) {
        return OrderedIntervalsSource.build(Arrays.asList(subSources));
    }

    public static IntervalsSource unordered(IntervalsSource ... subSources) {
        return Intervals.unordered(true, subSources);
    }

    public static IntervalsSource unordered(boolean allowOverlaps, IntervalsSource ... subSources) {
        return UnorderedIntervalsSource.build(Arrays.asList(subSources), allowOverlaps);
    }

    public static IntervalsSource fixField(String field, IntervalsSource source) {
        return new FixedFieldIntervalsSource(field, source);
    }

    public static IntervalsSource nonOverlapping(IntervalsSource minuend, IntervalsSource subtrahend) {
        return new NonOverlappingIntervalsSource(minuend, subtrahend);
    }

    public static IntervalsSource overlapping(IntervalsSource source, IntervalsSource reference) {
        return new OverlappingIntervalsSource(source, reference);
    }

    public static IntervalsSource notWithin(IntervalsSource minuend, int positions, IntervalsSource subtrahend) {
        return new NonOverlappingIntervalsSource(minuend, Intervals.extend(subtrahend, positions, positions));
    }

    public static IntervalsSource within(IntervalsSource source, int positions, IntervalsSource reference) {
        return Intervals.containedBy(source, Intervals.extend(reference, positions, positions));
    }

    public static IntervalsSource notContaining(IntervalsSource minuend, IntervalsSource subtrahend) {
        return NotContainingIntervalsSource.build(minuend, subtrahend);
    }

    public static IntervalsSource containing(IntervalsSource big, IntervalsSource small) {
        return ContainingIntervalsSource.build(big, small);
    }

    public static IntervalsSource notContainedBy(IntervalsSource small, IntervalsSource big) {
        return NotContainedByIntervalsSource.build(small, big);
    }

    public static IntervalsSource containedBy(IntervalsSource small, IntervalsSource big) {
        return ContainedByIntervalsSource.build(small, big);
    }

    public static IntervalsSource atLeast(int minShouldMatch, IntervalsSource ... sources) {
        return new MinimumShouldMatchIntervalsSource(sources, minShouldMatch);
    }

    public static IntervalsSource before(IntervalsSource source, IntervalsSource reference) {
        return ContainedByIntervalsSource.build(source, Intervals.extend(new OffsetIntervalsSource(reference, true), Integer.MAX_VALUE, 0));
    }

    public static IntervalsSource after(IntervalsSource source, IntervalsSource reference) {
        return ContainedByIntervalsSource.build(source, Intervals.extend(new OffsetIntervalsSource(reference, false), 0, Integer.MAX_VALUE));
    }
}

