/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.FilterMatchesIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Matches;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchesIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchesUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryVisitor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalScoreFunction;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalScorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalsSource;

public final class IntervalQuery
extends Query {
    private final String field;
    private final IntervalsSource intervalsSource;
    private final IntervalScoreFunction scoreFunction;

    public IntervalQuery(String field, IntervalsSource intervalsSource) {
        this(field, intervalsSource, IntervalScoreFunction.saturationFunction(1.0f));
    }

    public IntervalQuery(String field, IntervalsSource intervalsSource, float pivot) {
        this(field, intervalsSource, IntervalScoreFunction.saturationFunction(pivot));
    }

    public IntervalQuery(String field, IntervalsSource intervalsSource, float pivot, float exp) {
        this(field, intervalsSource, IntervalScoreFunction.sigmoidFunction(pivot, exp));
    }

    private IntervalQuery(String field, IntervalsSource intervalsSource, IntervalScoreFunction scoreFunction) {
        this.field = field;
        this.intervalsSource = intervalsSource;
        this.scoreFunction = scoreFunction;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public String toString(String field) {
        return this.intervalsSource.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new IntervalWeight(this, boost, scoreMode);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            this.intervalsSource.visit(this.field, visitor);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalQuery that = (IntervalQuery)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.intervalsSource, that.intervalsSource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.intervalsSource);
    }

    private class IntervalWeight
    extends Weight {
        final ScoreMode scoreMode;
        final float boost;

        public IntervalWeight(Query query, float boost, ScoreMode scoreMode) {
            super(query);
            this.scoreMode = scoreMode;
            this.boost = boost;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            IntervalQuery.this.intervalsSource.visit(IntervalQuery.this.field, QueryVisitor.termCollector(terms));
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            IntervalScorer scorer = (IntervalScorer)this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq = scorer.freq();
                return IntervalQuery.this.scoreFunction.explain(IntervalQuery.this.intervalsSource.toString(), this.boost, freq);
            }
            return Explanation.noMatch("no matching intervals", new Explanation[0]);
        }

        @Override
        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            return MatchesUtils.forField(IntervalQuery.this.field, () -> {
                MatchesIterator mi = IntervalQuery.this.intervalsSource.matches(IntervalQuery.this.field, context, doc);
                if (mi == null) {
                    return null;
                }
                return new FilterMatchesIterator(mi){

                    @Override
                    public Query getQuery() {
                        return new IntervalQuery(IntervalQuery.this.field, IntervalQuery.this.intervalsSource);
                    }
                };
            });
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            IntervalIterator intervals = IntervalQuery.this.intervalsSource.intervals(IntervalQuery.this.field, context);
            if (intervals == null) {
                return null;
            }
            return new IntervalScorer(this, intervals, IntervalQuery.this.intervalsSource.minExtent(), this.boost, IntervalQuery.this.scoreFunction);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }
}

