/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.intervals.IntervalIterator;

class ExtendedIntervalIterator
extends IntervalIterator {
    private final IntervalIterator in;
    private final int before;
    private final int after;
    private boolean positioned;

    ExtendedIntervalIterator(IntervalIterator in, int before, int after) {
        this.in = in;
        this.before = before;
        this.after = after;
    }

    @Override
    public int start() {
        if (!this.positioned) {
            return -1;
        }
        int start = this.in.start();
        if (start == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return Math.max(0, start - this.before);
    }

    @Override
    public int end() {
        if (!this.positioned) {
            return -1;
        }
        int end = this.in.end();
        if (end == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if ((end += this.after) < 0 || end == Integer.MAX_VALUE) {
            end = 0x7FFFFFFE;
        }
        return end;
    }

    @Override
    public int gaps() {
        return this.in.gaps();
    }

    @Override
    public int nextInterval() throws IOException {
        this.positioned = true;
        this.in.nextInterval();
        return this.start();
    }

    @Override
    public float matchCost() {
        return this.in.matchCost();
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        this.positioned = false;
        return this.in.nextDoc();
    }

    @Override
    public int advance(int target) throws IOException {
        this.positioned = false;
        return this.in.advance(target);
    }

    @Override
    public long cost() {
        return this.in.cost();
    }
}

