/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.LeafSimScorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.PhraseMatcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TwoPhaseIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;

class PhraseScorer
extends Scorer {
    final PhraseMatcher matcher;
    final ScoreMode scoreMode;
    private final LeafSimScorer simScorer;
    final float matchCost;
    private float minCompetitiveScore = 0.0f;
    private float freq = 0.0f;

    PhraseScorer(Weight weight, PhraseMatcher matcher, ScoreMode scoreMode, LeafSimScorer simScorer) {
        super(weight);
        this.matcher = matcher;
        this.scoreMode = scoreMode;
        this.simScorer = simScorer;
        this.matchCost = matcher.getMatchCost();
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return new TwoPhaseIterator(this.matcher.approximation){

            @Override
            public boolean matches() throws IOException {
                PhraseScorer.this.matcher.reset();
                if (PhraseScorer.this.scoreMode == ScoreMode.TOP_SCORES && PhraseScorer.this.minCompetitiveScore > 0.0f) {
                    float maxFreq = PhraseScorer.this.matcher.maxFreq();
                    if (PhraseScorer.this.simScorer.score(PhraseScorer.this.docID(), maxFreq) < PhraseScorer.this.minCompetitiveScore) {
                        return false;
                    }
                }
                PhraseScorer.this.freq = 0.0f;
                return PhraseScorer.this.matcher.nextMatch();
            }

            @Override
            public float matchCost() {
                return PhraseScorer.this.matchCost;
            }
        };
    }

    @Override
    public int docID() {
        return this.matcher.approximation.docID();
    }

    @Override
    public float score() throws IOException {
        if (this.freq == 0.0f) {
            this.freq = this.matcher.sloppyWeight();
            while (this.matcher.nextMatch()) {
                this.freq += this.matcher.sloppyWeight();
            }
        }
        return this.simScorer.score(this.docID(), this.freq);
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        this.minCompetitiveScore = minScore;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.simScorer.getSimScorer().score(2.1474836E9f, 1L);
    }

    public String toString() {
        return "PhraseScorer(" + this.weight + ")";
    }
}

