/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;

public final class FieldInfo {
    public final String name;
    public final int number;
    private DocValuesType docValuesType = DocValuesType.NONE;
    private boolean storeTermVector;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private boolean storePayloads;
    private final Map<String, String> attributes;
    private long dvGen;
    private int pointDataDimensionCount;
    private int pointIndexDimensionCount;
    private int pointNumBytes;
    private final boolean softDeletesField;

    public FieldInfo(String name, int number, boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, DocValuesType docValues, long dvGen, Map<String, String> attributes, int pointDataDimensionCount, int pointIndexDimensionCount, int pointNumBytes, boolean softDeletesField) {
        this.name = Objects.requireNonNull(name);
        this.number = number;
        this.docValuesType = Objects.requireNonNull(docValues, "DocValuesType must not be null (field: \"" + name + "\")");
        this.indexOptions = Objects.requireNonNull(indexOptions, "IndexOptions must not be null (field: \"" + name + "\")");
        if (indexOptions != IndexOptions.NONE) {
            this.storeTermVector = storeTermVector;
            this.storePayloads = storePayloads;
            this.omitNorms = omitNorms;
        } else {
            this.storeTermVector = false;
            this.storePayloads = false;
            this.omitNorms = false;
        }
        this.dvGen = dvGen;
        this.attributes = Objects.requireNonNull(attributes);
        this.pointDataDimensionCount = pointDataDimensionCount;
        this.pointIndexDimensionCount = pointIndexDimensionCount;
        this.pointNumBytes = pointNumBytes;
        this.softDeletesField = softDeletesField;
        assert (this.checkConsistency());
    }

    public boolean checkConsistency() {
        if (this.indexOptions != IndexOptions.NONE) {
            if (this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0 && this.storePayloads) {
                throw new IllegalStateException("indexed field '" + this.name + "' cannot have payloads without positions");
            }
        } else {
            if (this.storeTermVector) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot store term vectors");
            }
            if (this.storePayloads) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot store payloads");
            }
            if (this.omitNorms) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot omit norms");
            }
        }
        if (this.pointDataDimensionCount < 0) {
            throw new IllegalStateException("pointDataDimensionCount must be >= 0; got " + this.pointDataDimensionCount);
        }
        if (this.pointIndexDimensionCount < 0) {
            throw new IllegalStateException("pointIndexDimensionCount must be >= 0; got " + this.pointIndexDimensionCount);
        }
        if (this.pointNumBytes < 0) {
            throw new IllegalStateException("pointNumBytes must be >= 0; got " + this.pointNumBytes);
        }
        if (this.pointDataDimensionCount != 0 && this.pointNumBytes == 0) {
            throw new IllegalStateException("pointNumBytes must be > 0 when pointDataDimensionCount=" + this.pointDataDimensionCount);
        }
        if (this.pointIndexDimensionCount != 0 && this.pointDataDimensionCount == 0) {
            throw new IllegalStateException("pointIndexDimensionCount must be 0 when pointDataDimensionCount=0");
        }
        if (this.pointNumBytes != 0 && this.pointDataDimensionCount == 0) {
            throw new IllegalStateException("pointDataDimensionCount must be > 0 when pointNumBytes=" + this.pointNumBytes);
        }
        if (this.dvGen != -1L && this.docValuesType == DocValuesType.NONE) {
            throw new IllegalStateException("field '" + this.name + "' cannot have a docvalues update generation without having docvalues");
        }
        return true;
    }

    void update(boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, Map<String, String> attributes, int dataDimensionCount, int indexDimensionCount, int dimensionNumBytes) {
        if (indexOptions == null) {
            throw new NullPointerException("IndexOptions must not be null (field: \"" + this.name + "\")");
        }
        if (this.indexOptions != indexOptions) {
            if (this.indexOptions == IndexOptions.NONE) {
                this.indexOptions = indexOptions;
            } else if (indexOptions != IndexOptions.NONE) {
                throw new IllegalArgumentException("cannot change field \"" + this.name + "\" from index options=" + (Object)((Object)this.indexOptions) + " to inconsistent index options=" + (Object)((Object)indexOptions));
            }
        }
        if (this.pointDataDimensionCount == 0 && dataDimensionCount != 0) {
            this.pointDataDimensionCount = dataDimensionCount;
            this.pointIndexDimensionCount = indexDimensionCount;
            this.pointNumBytes = dimensionNumBytes;
        } else if (dataDimensionCount != 0 && (this.pointDataDimensionCount != dataDimensionCount || this.pointIndexDimensionCount != indexDimensionCount || this.pointNumBytes != dimensionNumBytes)) {
            throw new IllegalArgumentException("cannot change field \"" + this.name + "\" from points dataDimensionCount=" + this.pointDataDimensionCount + ", indexDimensionCount=" + this.pointIndexDimensionCount + ", numBytes=" + this.pointNumBytes + " to inconsistent dataDimensionCount=" + dataDimensionCount + ", indexDimensionCount=" + indexDimensionCount + ", numBytes=" + dimensionNumBytes);
        }
        if (this.indexOptions != IndexOptions.NONE) {
            this.storeTermVector |= storeTermVector;
            this.storePayloads |= storePayloads;
            if (indexOptions != IndexOptions.NONE && this.omitNorms != omitNorms) {
                this.omitNorms = true;
            }
        }
        if (this.indexOptions == IndexOptions.NONE || this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            this.storePayloads = false;
        }
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
        assert (this.checkConsistency());
    }

    public void setPointDimensions(int dataDimensionCount, int indexDimensionCount, int numBytes) {
        if (dataDimensionCount <= 0) {
            throw new IllegalArgumentException("point data dimension count must be >= 0; got " + dataDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (dataDimensionCount > 8) {
            throw new IllegalArgumentException("point data dimension count must be < PointValues.MAX_DIMENSIONS (= 8); got " + dataDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (indexDimensionCount > dataDimensionCount) {
            throw new IllegalArgumentException("point index dimension count must be <= point data dimension count (= " + dataDimensionCount + "); got " + indexDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (numBytes <= 0) {
            throw new IllegalArgumentException("point numBytes must be >= 0; got " + numBytes + " for field=\"" + this.name + "\"");
        }
        if (numBytes > 16) {
            throw new IllegalArgumentException("point numBytes must be <= PointValues.MAX_NUM_BYTES (= 16); got " + numBytes + " for field=\"" + this.name + "\"");
        }
        if (this.pointDataDimensionCount != 0 && this.pointDataDimensionCount != dataDimensionCount) {
            throw new IllegalArgumentException("cannot change point data dimension count from " + this.pointDataDimensionCount + " to " + dataDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (this.pointIndexDimensionCount != 0 && this.pointIndexDimensionCount != indexDimensionCount) {
            throw new IllegalArgumentException("cannot change point index dimension count from " + this.pointIndexDimensionCount + " to " + indexDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (this.pointNumBytes != 0 && this.pointNumBytes != numBytes) {
            throw new IllegalArgumentException("cannot change point numBytes from " + this.pointNumBytes + " to " + numBytes + " for field=\"" + this.name + "\"");
        }
        this.pointDataDimensionCount = dataDimensionCount;
        this.pointIndexDimensionCount = indexDimensionCount;
        this.pointNumBytes = numBytes;
        assert (this.checkConsistency());
    }

    public int getPointDataDimensionCount() {
        return this.pointDataDimensionCount;
    }

    public int getPointIndexDimensionCount() {
        return this.pointIndexDimensionCount;
    }

    public int getPointNumBytes() {
        return this.pointNumBytes;
    }

    public void setDocValuesType(DocValuesType type) {
        if (type == null) {
            throw new NullPointerException("DocValuesType must not be null (field: \"" + this.name + "\")");
        }
        if (this.docValuesType != DocValuesType.NONE && type != DocValuesType.NONE && this.docValuesType != type) {
            throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)this.docValuesType) + " to " + (Object)((Object)type) + " for field \"" + this.name + "\"");
        }
        this.docValuesType = type;
        assert (this.checkConsistency());
    }

    public IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    public void setIndexOptions(IndexOptions newIndexOptions) {
        if (this.indexOptions != newIndexOptions) {
            if (this.indexOptions == IndexOptions.NONE) {
                this.indexOptions = newIndexOptions;
            } else if (newIndexOptions != IndexOptions.NONE) {
                throw new IllegalArgumentException("cannot change field \"" + this.name + "\" from index options=" + (Object)((Object)this.indexOptions) + " to inconsistent index options=" + (Object)((Object)newIndexOptions));
            }
        }
        if (this.indexOptions == IndexOptions.NONE || this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            this.storePayloads = false;
        }
    }

    public DocValuesType getDocValuesType() {
        return this.docValuesType;
    }

    void setDocValuesGen(long dvGen) {
        this.dvGen = dvGen;
        assert (this.checkConsistency());
    }

    public long getDocValuesGen() {
        return this.dvGen;
    }

    void setStoreTermVectors() {
        this.storeTermVector = true;
        assert (this.checkConsistency());
    }

    void setStorePayloads() {
        if (this.indexOptions != IndexOptions.NONE && this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            this.storePayloads = true;
        }
        assert (this.checkConsistency());
    }

    public boolean omitsNorms() {
        return this.omitNorms;
    }

    public void setOmitsNorms() {
        if (this.indexOptions == IndexOptions.NONE) {
            throw new IllegalStateException("cannot omit norms: this field is not indexed");
        }
        this.omitNorms = true;
    }

    public boolean hasNorms() {
        return this.indexOptions != IndexOptions.NONE && !this.omitNorms;
    }

    public boolean hasPayloads() {
        return this.storePayloads;
    }

    public boolean hasVectors() {
        return this.storeTermVector;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String putAttribute(String key, String value) {
        return this.attributes.put(key, value);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public boolean isSoftDeletesField() {
        return this.softDeletesField;
    }
}

