/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LatLonShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LatLonShapeQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Rectangle;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Rectangle2D;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PointValues;

final class LatLonShapeBoundingBoxQuery
extends LatLonShapeQuery {
    final Rectangle2D rectangle2D;

    public LatLonShapeBoundingBoxQuery(String field, LatLonShape.QueryRelation queryRelation, double minLat, double maxLat, double minLon, double maxLon) {
        super(field, queryRelation);
        Rectangle rectangle = new Rectangle(minLat, maxLat, minLon, maxLon);
        this.rectangle2D = Rectangle2D.create(rectangle);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        return this.rectangle2D.relateRangeBBox(minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
    }

    @Override
    protected boolean queryMatches(byte[] t, int[] scratchTriangle, LatLonShape.QueryRelation queryRelation) {
        LatLonShape.decodeTriangle(t, scratchTriangle);
        int aY = scratchTriangle[0];
        int aX = scratchTriangle[1];
        int bY = scratchTriangle[2];
        int bX = scratchTriangle[3];
        int cY = scratchTriangle[4];
        int cX = scratchTriangle[5];
        if (queryRelation == LatLonShape.QueryRelation.WITHIN) {
            return this.rectangle2D.containsTriangle(aX, aY, bX, bY, cX, cY);
        }
        return this.rectangle2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(this.getClass().cast(o));
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && this.rectangle2D.equals(((LatLonShapeBoundingBoxQuery)o).rectangle2D);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.rectangle2D.hashCode();
        return hash;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.rectangle2D.toString());
        return sb.toString();
    }
}

