/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.blocktree.IntersectTermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.blocktree.SegmentTermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.blocktree.Stats;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteArrayDataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBufferIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountables;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.fst.FST;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.fst.OffHeapFSTStore;

public final class FieldReader
extends Terms
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FieldReader.class) + 3L * RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    final long numTerms;
    final FieldInfo fieldInfo;
    final long sumTotalTermFreq;
    final long sumDocFreq;
    final int docCount;
    final long indexStartFP;
    final long rootBlockFP;
    final BytesRef rootCode;
    final BytesRef minTerm;
    final BytesRef maxTerm;
    final int longsSize;
    final BlockTreeTermsReader parent;
    final FST<BytesRef> index;
    final boolean isFSTOffHeap;

    FieldReader(BlockTreeTermsReader parent, FieldInfo fieldInfo, long numTerms, BytesRef rootCode, long sumTotalTermFreq, long sumDocFreq, int docCount, long indexStartFP, int longsSize, IndexInput indexIn, BytesRef minTerm, BytesRef maxTerm, boolean openedFromWriter, BlockTreeTermsReader.FSTLoadMode fstLoadMode) throws IOException {
        assert (numTerms > 0L);
        this.fieldInfo = fieldInfo;
        this.parent = parent;
        this.numTerms = numTerms;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
        this.docCount = docCount;
        this.indexStartFP = indexStartFP;
        this.rootCode = rootCode;
        this.longsSize = longsSize;
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.rootBlockFP = new ByteArrayDataInput(rootCode.bytes, rootCode.offset, rootCode.length).readVLong() >>> 2;
        if (indexIn != null) {
            switch (fstLoadMode) {
                case ON_HEAP: {
                    this.isFSTOffHeap = false;
                    break;
                }
                case OFF_HEAP: {
                    this.isFSTOffHeap = true;
                    break;
                }
                case OPTIMIZE_UPDATES_OFF_HEAP: {
                    this.isFSTOffHeap = (long)this.docCount != this.sumDocFreq || !openedFromWriter;
                    break;
                }
                case AUTO: {
                    this.isFSTOffHeap = ((long)this.docCount != this.sumDocFreq || !openedFromWriter) && indexIn instanceof ByteBufferIndexInput;
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown enum constant: " + (Object)((Object)fstLoadMode));
                }
            }
            IndexInput clone = indexIn.clone();
            clone.seek(indexStartFP);
            this.index = this.isFSTOffHeap ? new FST<BytesRef>(clone, ByteSequenceOutputs.getSingleton(), new OffHeapFSTStore()) : new FST<BytesRef>(clone, ByteSequenceOutputs.getSingleton());
        } else {
            this.isFSTOffHeap = false;
            this.index = null;
        }
    }

    @Override
    public BytesRef getMin() throws IOException {
        if (this.minTerm == null) {
            return super.getMin();
        }
        return this.minTerm;
    }

    @Override
    public BytesRef getMax() throws IOException {
        if (this.maxTerm == null) {
            return super.getMax();
        }
        return this.maxTerm;
    }

    @Override
    public Stats getStats() throws IOException {
        return new SegmentTermsEnum(this).computeBlockStats();
    }

    @Override
    public boolean hasFreqs() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    @Override
    public boolean hasOffsets() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    @Override
    public boolean hasPositions() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    @Override
    public boolean hasPayloads() {
        return this.fieldInfo.hasPayloads();
    }

    @Override
    public TermsEnum iterator() throws IOException {
        return new SegmentTermsEnum(this);
    }

    @Override
    public long size() {
        return this.numTerms;
    }

    @Override
    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    @Override
    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    @Override
    public int getDocCount() {
        return this.docCount;
    }

    @Override
    public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        return new IntersectTermsEnum(this, compiled.automaton, compiled.runAutomaton, compiled.commonSuffixRef, startTerm);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + (this.index != null ? this.index.ramBytesUsed() : 0L);
    }

    @Override
    public Collection<Accountable> getChildResources() {
        if (this.index == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(Accountables.namedAccountable("term index", this.index));
    }

    public String toString() {
        return "BlockTreeTerms(seg=" + this.parent.segment + " terms=" + this.numTerms + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
    }

    public boolean isFstOffHeap() {
        return this.isFSTOffHeap;
    }
}

