/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.logging.slf4j;

import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.spi.CleanableThreadContextMap;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.util.StringMap;
import org.slf4j.MDC;

public class MDCContextMap
implements CleanableThreadContextMap {
    private static final StringMap EMPTY_CONTEXT_DATA = new SortedArrayStringMap(1);

    @Override
    public void put(String key, String value) {
        MDC.put((String)key, (String)value);
    }

    @Override
    public void putAll(Map<String, String> m) {
        for (Map.Entry<String, String> entry : m.entrySet()) {
            MDC.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public String get(String key) {
        return MDC.get((String)key);
    }

    @Override
    public void remove(String key) {
        MDC.remove((String)key);
    }

    @Override
    public void removeAll(Iterable<String> keys) {
        for (String key : keys) {
            MDC.remove((String)key);
        }
    }

    @Override
    public void clear() {
        MDC.clear();
    }

    @Override
    public boolean containsKey(String key) {
        return MDC.getCopyOfContextMap().containsKey(key);
    }

    @Override
    public Map<String, String> getCopy() {
        return MDC.getCopyOfContextMap();
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        return MDC.getCopyOfContextMap();
    }

    @Override
    public boolean isEmpty() {
        return MDC.getCopyOfContextMap().isEmpty();
    }

    @Override
    public StringMap getReadOnlyContextData() {
        Map<String, String> copy = this.getCopy();
        if (copy.isEmpty()) {
            return EMPTY_CONTEXT_DATA;
        }
        SortedArrayStringMap result = new SortedArrayStringMap();
        for (Map.Entry<String, String> entry : copy.entrySet()) {
            result.putValue(entry.getKey(), entry.getValue());
        }
        return result;
    }

    static {
        EMPTY_CONTEXT_DATA.freeze();
    }
}

