/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.transport.TransportAddress;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public final class RemoteConnectionInfo
implements ToXContentFragment,
Writeable {
    final List<TransportAddress> seedNodes;
    final List<TransportAddress> httpAddresses;
    final int connectionsPerCluster;
    final TimeValue initialConnectionTimeout;
    final int numNodesConnected;
    final String clusterAlias;
    final boolean skipUnavailable;

    RemoteConnectionInfo(String clusterAlias, List<TransportAddress> seedNodes, List<TransportAddress> httpAddresses, int connectionsPerCluster, int numNodesConnected, TimeValue initialConnectionTimeout, boolean skipUnavailable) {
        this.clusterAlias = clusterAlias;
        this.seedNodes = seedNodes;
        this.httpAddresses = httpAddresses;
        this.connectionsPerCluster = connectionsPerCluster;
        this.numNodesConnected = numNodesConnected;
        this.initialConnectionTimeout = initialConnectionTimeout;
        this.skipUnavailable = skipUnavailable;
    }

    public RemoteConnectionInfo(StreamInput input) throws IOException {
        this.seedNodes = input.readList(TransportAddress::new);
        this.httpAddresses = input.readList(TransportAddress::new);
        this.connectionsPerCluster = input.readVInt();
        this.initialConnectionTimeout = input.readTimeValue();
        this.numNodesConnected = input.readVInt();
        this.clusterAlias = input.readString();
        this.skipUnavailable = input.getVersion().onOrAfter(Version.V_6_1_0) ? input.readBoolean() : false;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.clusterAlias);
        builder.startArray("seeds");
        for (TransportAddress addr : this.seedNodes) {
            builder.value(addr.toString());
        }
        builder.endArray();
        builder.startArray("http_addresses");
        for (TransportAddress addr : this.httpAddresses) {
            builder.value(addr.toString());
        }
        builder.endArray();
        builder.field("connected", this.numNodesConnected > 0);
        builder.field("num_nodes_connected", this.numNodesConnected);
        builder.field("max_connections_per_cluster", this.connectionsPerCluster);
        builder.field("initial_connect_timeout", this.initialConnectionTimeout);
        builder.field("skip_unavailable", this.skipUnavailable);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.seedNodes);
        out.writeList(this.httpAddresses);
        out.writeVInt(this.connectionsPerCluster);
        out.writeTimeValue(this.initialConnectionTimeout);
        out.writeVInt(this.numNodesConnected);
        out.writeString(this.clusterAlias);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeBoolean(this.skipUnavailable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConnectionInfo that = (RemoteConnectionInfo)o;
        return this.connectionsPerCluster == that.connectionsPerCluster && this.numNodesConnected == that.numNodesConnected && Objects.equals(this.seedNodes, that.seedNodes) && Objects.equals(this.httpAddresses, that.httpAddresses) && Objects.equals(this.initialConnectionTimeout, that.initialConnectionTimeout) && Objects.equals(this.clusterAlias, that.clusterAlias) && this.skipUnavailable == that.skipUnavailable;
    }

    public int hashCode() {
        return Objects.hash(this.seedNodes, this.httpAddresses, this.connectionsPerCluster, this.initialConnectionTimeout, this.numNodesConnected, this.clusterAlias, this.skipUnavailable);
    }
}

