/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestIndexPutAliasAction
extends BaseRestHandler {
    public RestIndexPutAliasAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_aliases/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_aliases/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_alias", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_alias", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_aliases/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_aliases/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_aliases", this);
    }

    @Override
    public String getName() {
        return "index_put_alias_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String alias = request.param("name");
        Map<String, Object> filter = null;
        String routing = null;
        String indexRouting = null;
        String searchRouting = null;
        if (request.hasContent()) {
            try (XContentParser parser = request.contentParser();){
                XContentParser.Token token = parser.nextToken();
                if (token == null) {
                    throw new IllegalArgumentException("No index alias is specified");
                }
                String currentFieldName = null;
                while ((token = parser.nextToken()) != null) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if ("index".equals(currentFieldName)) {
                            indices = Strings.splitStringByCommaToArray(parser.text());
                            continue;
                        }
                        if ("alias".equals(currentFieldName)) {
                            alias = parser.text();
                            continue;
                        }
                        if ("routing".equals(currentFieldName)) {
                            routing = parser.textOrNull();
                            continue;
                        }
                        if ("indexRouting".equals(currentFieldName) || "index-routing".equals(currentFieldName) || "index_routing".equals(currentFieldName)) {
                            indexRouting = parser.textOrNull();
                            continue;
                        }
                        if (!"searchRouting".equals(currentFieldName) && !"search-routing".equals(currentFieldName) && !"search_routing".equals(currentFieldName)) continue;
                        searchRouting = parser.textOrNull();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT || !"filter".equals(currentFieldName)) continue;
                    filter = parser.mapOrdered();
                }
            }
        }
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.timeout(request.paramAsTime("timeout", indicesAliasesRequest.timeout()));
        indicesAliasesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", indicesAliasesRequest.masterNodeTimeout()));
        IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().indices(indices).alias(alias);
        if (routing != null) {
            aliasAction.routing(routing);
        }
        if (searchRouting != null) {
            aliasAction.searchRouting(searchRouting);
        }
        if (indexRouting != null) {
            aliasAction.indexRouting(indexRouting);
        }
        if (filter != null) {
            aliasAction.filter(filter);
        }
        indicesAliasesRequest.addAliasAction(aliasAction);
        return channel -> client.admin().indices().aliases(indicesAliasesRequest, new RestToXContentListener<IndicesAliasesResponse>((RestChannel)channel));
    }
}

