/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.Channels;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog.BaseTranslogReader;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog.Checkpoint;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog.TranslogHeader;

public class TranslogReader
extends BaseTranslogReader
implements Closeable {
    protected final long length;
    private final int totalOperations;
    private final Checkpoint checkpoint;
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    TranslogReader(Checkpoint checkpoint, FileChannel channel, Path path, TranslogHeader header) {
        super(checkpoint.generation, channel, path, header);
        this.length = checkpoint.offset;
        this.totalOperations = checkpoint.numOps;
        this.checkpoint = checkpoint;
    }

    public static TranslogReader open(FileChannel channel, Path path, Checkpoint checkpoint, String translogUUID) throws IOException {
        TranslogHeader header = TranslogHeader.read(translogUUID, path, channel);
        return new TranslogReader(checkpoint, channel, path, header);
    }

    @Override
    public long sizeInBytes() {
        return this.length;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    final Checkpoint getCheckpoint() {
        return this.checkpoint;
    }

    @Override
    protected void readBytes(ByteBuffer buffer, long position) throws IOException {
        if (position >= this.length) {
            throw new EOFException("read requested past EOF. pos [" + position + "] end: [" + this.length + "]");
        }
        if (position < this.getFirstOperationOffset()) {
            throw new IOException("read requested before position of first ops. pos [" + position + "] first op on: [" + this.getFirstOperationOffset() + "]");
        }
        Channels.readFromFileChannelWithEofException(this.channel, position, buffer);
    }

    @Override
    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.channel.close();
        }
    }

    protected final boolean isClosed() {
        return this.closed.get();
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new AlreadyClosedException(this.toString() + " is already closed");
        }
    }
}

