/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.plain;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.FieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public abstract class AbstractAtomicOrdinalsFieldData
implements AtomicOrdinalsFieldData {
    public static final Function<SortedSetDocValues, ScriptDocValues<?>> DEFAULT_SCRIPT_FUNCTION = ((Function<SortedSetDocValues, SortedBinaryDocValues>)FieldData::toString).andThen(ScriptDocValues.Strings::new);
    private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;

    protected AbstractAtomicOrdinalsFieldData(Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        this.scriptFunction = scriptFunction;
    }

    @Override
    public final ScriptDocValues<?> getScriptValues() {
        return this.scriptFunction.apply(this.getOrdinalsValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getOrdinalsValues());
    }

    public static AtomicOrdinalsFieldData empty() {
        return new AbstractAtomicOrdinalsFieldData((Function)DEFAULT_SCRIPT_FUNCTION){

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }

            @Override
            public void close() {
            }

            @Override
            public SortedSetDocValues getOrdinalsValues() {
                return DocValues.emptySortedSet();
            }
        };
    }
}

