/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SourceProvider {
    public static final Object UNKNOWN_SOURCE = "[unknown source]";
    private final Set<String> classNamesToSkip;
    public static final SourceProvider DEFAULT_INSTANCE = new SourceProvider();

    public SourceProvider() {
        this.classNamesToSkip = Collections.singleton(SourceProvider.class.getName());
    }

    private SourceProvider(SourceProvider copy, Class[] moreClassesToSkip) {
        HashSet<String> classNamesToSkip = new HashSet<String>(copy.classNamesToSkip);
        for (Class toSkip : moreClassesToSkip) {
            classNamesToSkip.add(toSkip.getName());
        }
        this.classNamesToSkip = Collections.unmodifiableSet(classNamesToSkip);
    }

    public SourceProvider plusSkippedClasses(Class ... moreClassesToSkip) {
        return new SourceProvider(this, moreClassesToSkip);
    }

    public StackTraceElement get() {
        for (StackTraceElement element : new Throwable().getStackTrace()) {
            String className = element.getClassName();
            if (this.classNamesToSkip.contains(className)) continue;
            return element;
        }
        throw new AssertionError();
    }
}

