/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.bootstrap;

import java.io.IOException;
import java.nio.file.Path;
import java.security.Permission;
import java.util.Arrays;
import java.util.Locale;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Build;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.bootstrap.Bootstrap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.bootstrap.BootstrapException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.bootstrap.StartupException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli.EnvironmentAwareCommand;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli.Terminal;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli.UserException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.LogConfigurator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.Environment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.monitor.jvm.JvmInfo;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.node.NodeValidationException;

class Elasticsearch
extends EnvironmentAwareCommand {
    private final OptionSpecBuilder versionOption;
    private final OptionSpecBuilder daemonizeOption;
    private final OptionSpec<Path> pidfileOption;
    private final OptionSpecBuilder quietOption;

    Elasticsearch() {
        super("starts elasticsearch", () -> {});
        this.versionOption = this.parser.acceptsAll(Arrays.asList("V", "version"), "Prints elasticsearch version information and exits");
        this.daemonizeOption = this.parser.acceptsAll(Arrays.asList("d", "daemonize"), "Starts Elasticsearch in the background").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]);
        this.pidfileOption = this.parser.acceptsAll(Arrays.asList("p", "pidfile"), "Creates a pid file in the specified path on start").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        this.quietOption = this.parser.acceptsAll(Arrays.asList("q", "quiet"), "Turns off standard output/error streams logging in console").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).availableUnless((OptionSpec)this.daemonizeOption, new OptionSpec[0]);
    }

    public static void main(String[] args) throws Exception {
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        LogConfigurator.registerErrorListener();
        Elasticsearch elasticsearch = new Elasticsearch();
        int status = Elasticsearch.main(args, elasticsearch, Terminal.DEFAULT);
        if (status != 0) {
            Elasticsearch.exit(status);
        }
    }

    static int main(String[] args, Elasticsearch elasticsearch, Terminal terminal) throws Exception {
        return elasticsearch.main(args, terminal);
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws UserException {
        if (!options.nonOptionArguments().isEmpty()) {
            throw new UserException(64, "Positional arguments not allowed, found " + options.nonOptionArguments());
        }
        if (options.has((OptionSpec)this.versionOption)) {
            String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s/%s, JVM: %s", Version.displayVersion(Version.CURRENT, Build.CURRENT.isSnapshot()), Build.CURRENT.flavor().displayName(), Build.CURRENT.type().displayName(), Build.CURRENT.shortHash(), Build.CURRENT.date(), JvmInfo.jvmInfo().version());
            terminal.println(versionOutput);
            return;
        }
        boolean daemonize = options.has((OptionSpec)this.daemonizeOption);
        Path pidFile = (Path)this.pidfileOption.value(options);
        boolean quiet = options.has((OptionSpec)this.quietOption);
        try {
            env.validateTmpFile();
        }
        catch (IOException e) {
            throw new UserException(78, e.getMessage());
        }
        try {
            this.init(daemonize, pidFile, quiet, env);
        }
        catch (NodeValidationException e) {
            throw new UserException(78, e.getMessage());
        }
    }

    void init(boolean daemonize, Path pidFile, boolean quiet, Environment initialEnv) throws NodeValidationException, UserException {
        try {
            Bootstrap.init(!daemonize, pidFile, quiet, initialEnv);
        }
        catch (RuntimeException | BootstrapException e) {
            throw new StartupException(e);
        }
    }

    static void close(String[] args) throws IOException {
        Bootstrap.stop();
    }
}

