/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class ShardsAcknowledgedResponse
extends AcknowledgedResponse {
    private static final ParseField SHARDS_ACKNOWLEDGED = new ParseField("shards_acknowledged", new String[0]);
    private boolean shardsAcknowledged;

    protected static <T extends ShardsAcknowledgedResponse> void declareAcknowledgedAndShardsAcknowledgedFields(ConstructingObjectParser<T, Void> objectParser) {
        ShardsAcknowledgedResponse.declareAcknowledgedField(objectParser);
        objectParser.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.booleanValue(), SHARDS_ACKNOWLEDGED, ObjectParser.ValueType.BOOLEAN);
    }

    protected ShardsAcknowledgedResponse() {
    }

    protected ShardsAcknowledgedResponse(boolean acknowledged, boolean shardsAcknowledged) {
        super(acknowledged);
        assert (acknowledged || !shardsAcknowledged);
        this.shardsAcknowledged = shardsAcknowledged;
    }

    public boolean isShardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    protected void readShardsAcknowledged(StreamInput in) throws IOException {
        this.shardsAcknowledged = in.readBoolean();
    }

    protected void writeShardsAcknowledged(StreamOutput out) throws IOException {
        out.writeBoolean(this.shardsAcknowledged);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SHARDS_ACKNOWLEDGED.getPreferredName(), this.isShardsAcknowledged());
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            ShardsAcknowledgedResponse that = (ShardsAcknowledgedResponse)o;
            return this.shardsAcknowledged == that.shardsAcknowledged;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shardsAcknowledged);
    }
}

