/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.DocIdSetBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesCollectorQueue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;

class TermsSortedDocsProducer
extends SortedDocsProducer {
    TermsSortedDocsProducer(String field) {
        super(field);
    }

    @Override
    DocIdSet processLeaf(Query query, CompositeValuesCollectorQueue queue, LeafReaderContext context, boolean fillDocIdSet) throws IOException {
        Terms terms = context.reader().terms(this.field);
        if (terms == null) {
            return DocIdSet.EMPTY;
        }
        BytesRef lowerValue = (BytesRef)queue.getLowerValueLeadSource();
        BytesRef upperValue = (BytesRef)queue.getUpperValueLeadSource();
        TermsEnum te = terms.iterator();
        if (lowerValue != null ? te.seekCeil(lowerValue) == TermsEnum.SeekStatus.END : te.next() == null) {
            return DocIdSet.EMPTY;
        }
        DocIdSetBuilder builder = fillDocIdSet ? new DocIdSetBuilder(context.reader().maxDoc(), terms) : null;
        PostingsEnum reuse = null;
        boolean first = true;
        while (!(upperValue != null && upperValue.compareTo(te.term()) < 0 || this.processBucket(queue, context, reuse = te.postings(reuse, 0), te.term(), builder) && !first)) {
            first = false;
            if (te.next() != null) continue;
        }
        return fillDocIdSet ? builder.build() : DocIdSet.EMPTY;
    }
}

