/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.search;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.explain.ExplainRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.explain.ExplainResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.get.GetResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BytesRestResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestActions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestBuilderListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class RestExplainAction
extends BaseRestHandler {
    public RestExplainAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_explain", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_explain", this);
    }

    @Override
    public String getName() {
        return "explain_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String[] sFields;
        ExplainRequest explainRequest = new ExplainRequest(request.param("index"), request.param("type"), request.param("id"));
        explainRequest.parent(request.param("parent"));
        explainRequest.routing(request.param("routing"));
        explainRequest.preference(request.param("preference"));
        String queryString = request.param("q");
        request.withContentOrSourceParamParserOrNull(parser -> {
            if (parser != null) {
                explainRequest.query(RestActions.getQueryContent(parser));
            } else if (queryString != null) {
                QueryBuilder query = RestActions.urlParamsToQueryBuilder(request);
                explainRequest.query(query);
            }
        });
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("The parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields");
        }
        String sField = request.param("stored_fields");
        if (sField != null && (sFields = Strings.splitStringByCommaToArray(sField)) != null) {
            explainRequest.storedFields(sFields);
        }
        explainRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> client.explain(explainRequest, (ActionListener<ExplainResponse>)new RestBuilderListener<ExplainResponse>(channel){

            @Override
            public RestResponse buildResponse(ExplainResponse response, XContentBuilder builder) throws Exception {
                GetResult getResult;
                builder.startObject();
                builder.field("_index", response.getIndex()).field("_type", response.getType()).field("_id", response.getId()).field("matched", response.isMatch());
                if (response.hasExplanation()) {
                    builder.startObject("explanation");
                    this.buildExplanation(builder, response.getExplanation());
                    builder.endObject();
                }
                if ((getResult = response.getGetResult()) != null) {
                    builder.startObject("get");
                    response.getGetResult().toXContentEmbedded(builder, request);
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(response.isExists() ? RestStatus.OK : RestStatus.NOT_FOUND, builder);
            }

            private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
                builder.field("value", explanation.getValue());
                builder.field("description", explanation.getDescription());
                Explanation[] innerExps = explanation.getDetails();
                if (innerExps != null) {
                    builder.startArray("details");
                    for (Explanation exp : innerExps) {
                        builder.startObject();
                        this.buildExplanation(builder, exp);
                        builder.endObject();
                    }
                    builder.endArray();
                }
            }
        });
    }

    static class Fields {
        static final String _INDEX = "_index";
        static final String _TYPE = "_type";
        static final String _ID = "_id";
        static final String MATCHED = "matched";
        static final String EXPLANATION = "explanation";
        static final String VALUE = "value";
        static final String DESCRIPTION = "description";
        static final String DETAILS = "details";
        static final String GET = "get";

        Fields() {
        }
    }
}

