/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.monitor.os;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.SingleObjectCache;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsExecutors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.monitor.os.OsInfo;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.monitor.os.OsProbe;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.monitor.os.OsStats;

public class OsService
extends AbstractComponent {
    private final OsProbe probe = OsProbe.getInstance();
    private final OsInfo info;
    private final SingleObjectCache<OsStats> osStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.os.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public OsService(Settings settings) {
        super(settings);
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.info = this.probe.osInfo(refreshInterval.millis(), EsExecutors.numberOfProcessors(settings));
        this.osStatsCache = new OsStatsCache(refreshInterval, this.probe.osStats());
        this.logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    public OsInfo info() {
        return this.info;
    }

    public synchronized OsStats stats() {
        return this.osStatsCache.getOrRefresh();
    }

    private class OsStatsCache
    extends SingleObjectCache<OsStats> {
        OsStatsCache(TimeValue interval, OsStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected OsStats refresh() {
            return OsService.this.probe.osStats();
        }
    }
}

