/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexWriterConfig;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.MergePolicy;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SegmentCommitInfo;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SegmentInfos;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ReferenceManager;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.SearcherFactory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.SearcherManager;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.LockObtainFailedException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.InfoStream;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.SuppressForbidden;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.LoggerInfoStream;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.metrics.CounterMetric;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.VersionType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.CombinedDeletionPolicy;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.DeleteVersionValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.ElasticsearchConcurrentMergeScheduler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.Engine;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.EngineConfig;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.EngineCreationFailureException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.EngineException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.EngineSearcher;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.EngineSearcherFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.FlushFailedEngineException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.IndexVersionValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.LiveVersionMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.RamAccountingSearcherFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.Segment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.SegmentsStats;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.TranslogLeafReader;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.VersionConflictEngineException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.VersionValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.merge.MergeStats;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.merge.OnGoingMerge;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.seqno.SequenceNumbers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ElasticsearchMergePolicy;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog.Translog;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog.TranslogConfig;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog.TranslogCorruptedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog.TranslogDeletionPolicy;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class InternalEngine
extends Engine {
    private volatile long lastDeleteVersionPruneTimeMSec;
    private final Translog translog;
    private final ElasticsearchConcurrentMergeScheduler mergeScheduler;
    private final IndexWriter indexWriter;
    private final ExternalSearcherManager externalSearcherManager;
    private final SearcherManager internalSearcherManager;
    private final Lock flushLock;
    private final ReentrantLock optimizeLock;
    private final LiveVersionMap versionMap;
    private volatile SegmentInfos lastCommittedSegmentInfos;
    private final Engine.IndexThrottle throttle;
    private final LocalCheckpointTracker localCheckpointTracker;
    private final String uidField;
    private final CombinedDeletionPolicy combinedDeletionPolicy;
    private final AtomicInteger throttleRequestCount;
    private final AtomicBoolean pendingTranslogRecovery;
    public static final String MAX_UNSAFE_AUTO_ID_TIMESTAMP_COMMIT_ID = "max_unsafe_auto_id_timestamp";
    private final AtomicLong maxUnsafeAutoIdTimestamp;
    private final AtomicLong maxSeqNoOfNonAppendOnlyOperations;
    private final CounterMetric numVersionLookups;
    private final CounterMetric numIndexVersionsLookups;
    private final CounterMetric numDocDeletes;
    private final CounterMetric numDocAppends;
    private final CounterMetric numDocUpdates;
    private final AtomicLong writingBytes;
    private final AtomicBoolean trackTranslogLocation;
    @Nullable
    private final String historyUUID;

    public InternalEngine(EngineConfig engineConfig) {
        this(engineConfig, LocalCheckpointTracker::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InternalEngine(EngineConfig engineConfig, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) {
        block14: {
            super(engineConfig);
            this.flushLock = new ReentrantLock();
            this.optimizeLock = new ReentrantLock();
            this.versionMap = new LiveVersionMap();
            this.throttleRequestCount = new AtomicInteger();
            this.pendingTranslogRecovery = new AtomicBoolean(false);
            this.maxUnsafeAutoIdTimestamp = new AtomicLong(-1L);
            this.maxSeqNoOfNonAppendOnlyOperations = new AtomicLong(-1L);
            this.numVersionLookups = new CounterMetric();
            this.numIndexVersionsLookups = new CounterMetric();
            this.numDocDeletes = new CounterMetric();
            this.numDocAppends = new CounterMetric();
            this.numDocUpdates = new CounterMetric();
            this.writingBytes = new AtomicLong();
            this.trackTranslogLocation = new AtomicBoolean(false);
            if (!engineConfig.isAutoGeneratedIDsOptimizationEnabled()) {
                this.maxUnsafeAutoIdTimestamp.set(Long.MAX_VALUE);
            }
            this.uidField = engineConfig.getIndexSettings().isSingleType() ? "_id" : "_uid";
            TranslogDeletionPolicy translogDeletionPolicy = new TranslogDeletionPolicy(engineConfig.getIndexSettings().getTranslogRetentionSize().getBytes(), engineConfig.getIndexSettings().getTranslogRetentionAge().getMillis());
            this.store.incRef();
            IndexWriter writer = null;
            Translog translog = null;
            ExternalSearcherManager externalSearcherManager = null;
            SearcherManager internalSearcherManager = null;
            EngineMergeScheduler scheduler = null;
            boolean success = false;
            try {
                this.lastDeleteVersionPruneTimeMSec = engineConfig.getThreadPool().relativeTimeInMillis();
                scheduler = new EngineMergeScheduler(engineConfig.getShardId(), engineConfig.getIndexSettings());
                this.mergeScheduler = scheduler;
                this.throttle = new Engine.IndexThrottle();
                try {
                    translog = this.openTranslog(engineConfig, translogDeletionPolicy, engineConfig.getGlobalCheckpointSupplier());
                    assert (translog.getGeneration() != null);
                    this.translog = translog;
                    this.localCheckpointTracker = this.createLocalCheckpointTracker(localCheckpointTrackerSupplier);
                    this.combinedDeletionPolicy = new CombinedDeletionPolicy(this.logger, translogDeletionPolicy, translog::getLastSyncedGlobalCheckpoint);
                    writer = this.createWriter();
                    this.bootstrapAppendOnlyInfoFromWriter(writer);
                    this.historyUUID = this.loadHistoryUUID(writer);
                    this.indexWriter = writer;
                }
                catch (IOException | TranslogCorruptedException e) {
                    throw new EngineCreationFailureException(this.shardId, "failed to create engine", e);
                }
                catch (AssertionError e) {
                    if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexWriter.filesExist")) {
                        throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)((Object)e));
                    }
                    throw e;
                }
                externalSearcherManager = this.createSearcherManager(new SearchFactory(this.logger, this.isClosed, engineConfig));
                this.internalSearcherManager = internalSearcherManager = externalSearcherManager.internalSearcherManager;
                this.externalSearcherManager = externalSearcherManager;
                internalSearcherManager.addListener(this.versionMap);
                assert (!this.pendingTranslogRecovery.get()) : "translog recovery can't be pending before we set it";
                this.pendingTranslogRecovery.set(true);
                for (ReferenceManager.RefreshListener listener : engineConfig.getExternalRefreshListener()) {
                    this.externalSearcherManager.addListener(listener);
                }
                for (ReferenceManager.RefreshListener listener : engineConfig.getInternalRefreshListener()) {
                    this.internalSearcherManager.addListener(listener);
                }
                success = true;
                if (success) break block14;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(writer, translog, internalSearcherManager, externalSearcherManager, scheduler);
                    if (!this.isClosed.get()) {
                        this.store.decRef();
                    }
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(writer, translog, internalSearcherManager, externalSearcherManager, scheduler);
            if (!this.isClosed.get()) {
                this.store.decRef();
            }
        }
        this.logger.trace("created new InternalEngine");
    }

    private LocalCheckpointTracker createLocalCheckpointTracker(BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) throws IOException {
        SequenceNumbers.CommitInfo seqNoStats = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.store.readLastCommittedSegmentsInfo().userData.entrySet());
        long maxSeqNo = seqNoStats.maxSeqNo;
        long localCheckpoint = seqNoStats.localCheckpoint;
        this.logger.trace("recovered maximum sequence number [{}] and local checkpoint [{}]", (Object)maxSeqNo, (Object)localCheckpoint);
        return localCheckpointTrackerSupplier.apply(maxSeqNo, localCheckpoint);
    }

    @Override
    public void restoreLocalCheckpointFromTranslog() throws IOException {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            this.ensureOpen();
            long localCheckpoint = this.localCheckpointTracker.getCheckpoint();
            try (Translog.Snapshot snapshot = this.getTranslog().newSnapshotFromMinSeqNo(localCheckpoint + 1L);){
                Translog.Operation operation;
                while ((operation = snapshot.next()) != null) {
                    if (operation.seqNo() <= localCheckpoint) continue;
                    this.localCheckpointTracker.markSeqNoAsCompleted(operation.seqNo());
                }
            }
        }
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) throws IOException {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            this.ensureOpen();
            long localCheckpoint = this.localCheckpointTracker.getCheckpoint();
            long maxSeqNo = this.localCheckpointTracker.getMaxSeqNo();
            int numNoOpsAdded = 0;
            long seqNo = localCheckpoint + 1L;
            while (seqNo <= maxSeqNo) {
                this.innerNoOp(new Engine.NoOp(seqNo, primaryTerm, Engine.Operation.Origin.PRIMARY, System.nanoTime(), "filling gaps"));
                ++numNoOpsAdded;
                assert (seqNo <= this.localCheckpointTracker.getCheckpoint()) : "local checkpoint did not advance; was [" + seqNo + "], now [" + this.localCheckpointTracker.getCheckpoint() + "]";
                seqNo = this.localCheckpointTracker.getCheckpoint() + 1L;
            }
            int n = numNoOpsAdded;
            return n;
        }
    }

    private void bootstrapAppendOnlyInfoFromWriter(IndexWriter writer) {
        for (Map.Entry<String, String> entry : writer.getLiveCommitData()) {
            String key = entry.getKey();
            if (key.equals(MAX_UNSAFE_AUTO_ID_TIMESTAMP_COMMIT_ID)) {
                assert (this.maxUnsafeAutoIdTimestamp.get() == -1L) : "max unsafe timestamp was assigned already [" + this.maxUnsafeAutoIdTimestamp.get() + "]";
                this.maxUnsafeAutoIdTimestamp.set(Long.parseLong(entry.getValue()));
            }
            if (!key.equals("max_seq_no")) continue;
            assert (this.maxSeqNoOfNonAppendOnlyOperations.get() == -1L) : "max unsafe append-only seq# was assigned already [" + this.maxSeqNoOfNonAppendOnlyOperations.get() + "]";
            this.maxSeqNoOfNonAppendOnlyOperations.set(Long.parseLong(entry.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalEngine recoverFromTranslog() throws IOException {
        this.flushLock.lock();
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            if (!this.pendingTranslogRecovery.get()) {
                throw new IllegalStateException("Engine has already been recovered");
            }
            try {
                this.recoverFromTranslogInternal();
            }
            catch (Exception e) {
                try {
                    this.pendingTranslogRecovery.set(true);
                    this.failEngine("failed to recover from translog", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw e;
            }
        }
        finally {
            this.flushLock.unlock();
        }
        return this;
    }

    @Override
    public void skipTranslogRecovery() {
        assert (this.pendingTranslogRecovery.get()) : "translogRecovery is not pending but should be";
        this.pendingTranslogRecovery.set(false);
    }

    private void recoverFromTranslogInternal() throws IOException {
        int opsRecovered;
        Translog.TranslogGeneration translogGeneration = this.translog.getGeneration();
        long translogGen = Long.parseLong(this.lastCommittedSegmentInfos.getUserData().get("translog_generation"));
        try (Translog.Snapshot snapshot = this.translog.newSnapshotFromGen(translogGen);){
            opsRecovered = this.config().getTranslogRecoveryRunner().run(this, snapshot);
        }
        catch (Exception e) {
            throw new EngineException(this.shardId, "failed to recover from translog", e, new Object[0]);
        }
        assert (this.pendingTranslogRecovery.get()) : "translogRecovery is not pending but should be";
        this.pendingTranslogRecovery.set(false);
        if (opsRecovered > 0) {
            this.logger.trace("flushing post recovery from translog. ops recovered [{}]. committed translog id [{}]. current id [{}]", (Object)opsRecovered, (Object)(translogGeneration == null ? null : Long.valueOf(translogGeneration.translogFileGeneration)), (Object)this.translog.currentFileGeneration());
            this.commitIndexWriter(this.indexWriter, this.translog, null);
            this.refreshLastCommittedSegmentInfos();
            this.refresh("translog_recovery");
        }
        this.translog.trimUnreferencedReaders();
    }

    private Translog openTranslog(EngineConfig engineConfig, TranslogDeletionPolicy translogDeletionPolicy, LongSupplier globalCheckpointSupplier) throws IOException {
        TranslogConfig translogConfig = engineConfig.getTranslogConfig();
        String translogUUID = this.loadTranslogUUIDFromLastCommit();
        if (engineConfig.getIndexSettings().getIndexVersionCreated().before(Version.V_6_0_0)) {
            SegmentInfos lastCommitInfo = this.store.readLastCommittedSegmentsInfo();
            long minRequiredTranslogGen = Long.parseLong(lastCommitInfo.userData.get("translog_generation"));
            translogDeletionPolicy.setTranslogGenerationOfLastCommit(minRequiredTranslogGen);
            translogDeletionPolicy.setMinTranslogGenerationForRecovery(minRequiredTranslogGen);
        }
        return new Translog(translogConfig, translogUUID, translogDeletionPolicy, globalCheckpointSupplier, engineConfig.getPrimaryTermSupplier());
    }

    @Override
    Translog getTranslog() {
        this.ensureOpen();
        return this.translog;
    }

    @Override
    public boolean ensureTranslogSynced(Stream<Translog.Location> locations) throws IOException {
        boolean synced = this.translog.ensureSynced(locations);
        if (synced) {
            this.revisitIndexDeletionPolicyOnTranslogSynced();
        }
        return synced;
    }

    @Override
    public void syncTranslog() throws IOException {
        this.translog.sync();
        this.revisitIndexDeletionPolicyOnTranslogSynced();
    }

    private void revisitIndexDeletionPolicyOnTranslogSynced() throws IOException {
        if (this.combinedDeletionPolicy.hasUnreferencedCommits()) {
            this.indexWriter.deleteUnusedFiles();
        }
    }

    @Override
    public String getHistoryUUID() {
        return this.historyUUID;
    }

    @Override
    public long getWritingBytes() {
        return this.writingBytes.get();
    }

    @Nullable
    private String loadTranslogUUIDFromLastCommit() throws IOException {
        Map<String, String> commitUserData = this.store.readLastCommittedSegmentsInfo().getUserData();
        if (!commitUserData.containsKey("translog_generation")) {
            throw new IllegalStateException("commit doesn't contain translog generation id");
        }
        return commitUserData.get("translog_uuid");
    }

    private String loadHistoryUUID(IndexWriter writer) throws IOException {
        String uuid = InternalEngine.commitDataAsMap(writer).get("history_uuid");
        if (uuid == null) {
            throw new IllegalStateException("commit doesn't contain history uuid");
        }
        return uuid;
    }

    private ExternalSearcherManager createSearcherManager(SearchFactory externalSearcherFactory) throws EngineException {
        ExternalSearcherManager externalSearcherManager;
        block7: {
            boolean success = false;
            SearcherManager internalSearcherManager = null;
            try {
                ElasticsearchDirectoryReader directoryReader = ElasticsearchDirectoryReader.wrap(DirectoryReader.open(this.indexWriter), this.shardId);
                internalSearcherManager = new SearcherManager(directoryReader, (SearcherFactory)new RamAccountingSearcherFactory(this.engineConfig.getCircuitBreakerService()));
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                ExternalSearcherManager externalSearcherManager2 = new ExternalSearcherManager(internalSearcherManager, externalSearcherFactory);
                success = true;
                externalSearcherManager = externalSearcherManager2;
                if (success) break block7;
            }
            catch (IOException e) {
                try {
                    this.maybeFailEngine("start", e);
                    try {
                        this.indexWriter.rollback();
                    }
                    catch (IOException inner) {
                        e.addSuppressed(inner);
                    }
                    throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", e);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(internalSearcherManager, this.indexWriter);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(internalSearcherManager, this.indexWriter);
        }
        return externalSearcherManager;
    }

    @Override
    public Engine.GetResult get(Engine.Get get, BiFunction<String, Engine.SearcherScope, Engine.Searcher> searcherFactory) throws EngineException {
        assert (Objects.equals(get.uid().field(), this.uidField)) : get.uid().field();
        try (ReleasableLock ignored = this.readLock.acquire();){
            Engine.SearcherScope scope;
            this.ensureOpen();
            if (get.realtime()) {
                VersionValue versionValue = null;
                try (Releasable ignore = this.versionMap.acquireLock(get.uid().bytes());){
                    versionValue = this.getVersionFromMap(get.uid().bytes());
                }
                if (versionValue != null) {
                    block26: {
                        if (versionValue.isDelete()) {
                            ignore = Engine.GetResult.NOT_EXISTS;
                            return ignore;
                        }
                        if (get.versionType().isVersionConflictForReads(versionValue.version, get.version())) {
                            throw new VersionConflictEngineException(this.shardId, get.type(), get.id(), get.versionType().explainConflictForReads(versionValue.version, get.version()));
                        }
                        if (get.isReadFromTranslog()) {
                            if (versionValue.getLocation() != null) {
                                try {
                                    Translog.Operation operation = this.translog.readOperation(versionValue.getLocation());
                                    if (operation != null) {
                                        TranslogLeafReader reader = new TranslogLeafReader((Translog.Index)operation, this.engineConfig.getIndexSettings().getIndexVersionCreated());
                                        Engine.GetResult getResult = new Engine.GetResult(new Engine.Searcher("realtime_get", new IndexSearcher(reader)), new VersionsAndSeqNoResolver.DocIdAndVersion(0, ((Translog.Index)operation).version(), reader, 0));
                                        return getResult;
                                    }
                                    break block26;
                                }
                                catch (IOException e) {
                                    this.maybeFailEngine("realtime_get", e);
                                    throw new EngineException(this.shardId, "failed to read operation from translog", e, new Object[0]);
                                }
                            }
                            this.trackTranslogLocation.set(true);
                        }
                    }
                    this.refresh("realtime_get", Engine.SearcherScope.INTERNAL);
                }
                scope = Engine.SearcherScope.INTERNAL;
            } else {
                scope = Engine.SearcherScope.EXTERNAL;
            }
            Engine.GetResult getResult = this.getFromSearcher(get, searcherFactory, scope);
            return getResult;
        }
    }

    private OpVsLuceneDocStatus compareOpToLuceneDocBasedOnSeqNo(Engine.Operation op) throws IOException {
        OpVsLuceneDocStatus status;
        assert (op.seqNo() != -2L) : "resolving ops based on seq# but no seqNo is found";
        VersionValue versionValue = this.getVersionFromMap(op.uid().bytes());
        assert (this.incrementVersionLookup());
        if (versionValue != null) {
            status = op.seqNo() > versionValue.seqNo || op.seqNo() == versionValue.seqNo && op.primaryTerm() > versionValue.term ? OpVsLuceneDocStatus.OP_NEWER : OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
        } else {
            assert (this.incrementIndexVersionLookup());
            try (Engine.Searcher searcher = this.acquireSearcher("load_seq_no", Engine.SearcherScope.INTERNAL);){
                VersionsAndSeqNoResolver.DocIdAndSeqNo docAndSeqNo = VersionsAndSeqNoResolver.loadDocIdAndSeqNo(searcher.reader(), op.uid());
                if (docAndSeqNo == null) {
                    status = OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND;
                } else if (op.seqNo() > docAndSeqNo.seqNo) {
                    status = OpVsLuceneDocStatus.OP_NEWER;
                } else if (op.seqNo() == docAndSeqNo.seqNo) {
                    long existingTerm = VersionsAndSeqNoResolver.loadPrimaryTerm(docAndSeqNo, op.uid().field());
                    status = op.primaryTerm() > existingTerm ? OpVsLuceneDocStatus.OP_NEWER : OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
                } else {
                    status = OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
                }
            }
        }
        return status;
    }

    private VersionValue resolveDocVersion(Engine.Operation op) throws IOException {
        assert (this.incrementVersionLookup());
        VersionValue versionValue = this.getVersionFromMap(op.uid().bytes());
        if (versionValue == null) {
            assert (this.incrementIndexVersionLookup());
            long currentVersion = this.loadCurrentVersionFromIndex(op.uid());
            if (currentVersion != -1L) {
                versionValue = new IndexVersionValue(null, currentVersion, -2L, 0L);
            }
        } else if (this.engineConfig.isEnableGcDeletes() && versionValue.isDelete() && this.engineConfig.getThreadPool().relativeTimeInMillis() - ((DeleteVersionValue)versionValue).time > this.getGcDeletesInMillis()) {
            versionValue = null;
        }
        return versionValue;
    }

    private OpVsLuceneDocStatus compareOpToLuceneDocBasedOnVersions(Engine.Operation op) throws IOException {
        assert (op.seqNo() == -2L) : "op is resolved based on versions but have a seq#";
        assert (op.version() >= 0L) : "versions should be non-negative. got " + op.version();
        VersionValue versionValue = this.resolveDocVersion(op);
        if (versionValue == null) {
            return OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND;
        }
        return op.versionType().isVersionConflictForWrites(versionValue.version, op.version(), versionValue.isDelete()) ? OpVsLuceneDocStatus.OP_STALE_OR_EQUAL : OpVsLuceneDocStatus.OP_NEWER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionValue getVersionFromMap(BytesRef id) {
        if (this.versionMap.isUnsafe()) {
            LiveVersionMap liveVersionMap = this.versionMap;
            synchronized (liveVersionMap) {
                if (this.versionMap.isUnsafe()) {
                    this.refresh("unsafe_version_map", Engine.SearcherScope.INTERNAL);
                }
                this.versionMap.enforceSafeAccess();
            }
        }
        return this.versionMap.getUnderLock(id);
    }

    private boolean canOptimizeAddDocument(Engine.Index index) {
        if (index.getAutoGeneratedIdTimestamp() != -1L) {
            assert (index.getAutoGeneratedIdTimestamp() >= 0L) : "autoGeneratedIdTimestamp must be positive but was: " + index.getAutoGeneratedIdTimestamp();
            switch (index.origin()) {
                case PRIMARY: {
                    assert (index.version() == -3L && index.versionType() == VersionType.INTERNAL) : "version: " + index.version() + " type: " + index.versionType();
                    return true;
                }
                case PEER_RECOVERY: 
                case REPLICA: {
                    assert (index.version() == 1L && index.versionType() == VersionType.EXTERNAL) : "version: " + index.version() + " type: " + index.versionType();
                    return true;
                }
                case LOCAL_TRANSLOG_RECOVERY: {
                    assert (index.isRetry());
                    return true;
                }
            }
            throw new IllegalArgumentException("unknown origin " + (Object)((Object)index.origin()));
        }
        return false;
    }

    private boolean assertVersionType(Engine.Operation operation) {
        if (operation.origin() == Engine.Operation.Origin.REPLICA || operation.origin() == Engine.Operation.Origin.PEER_RECOVERY || operation.origin() == Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY) assert (operation.versionType() == operation.versionType().versionTypeForReplicationAndRecovery()) : "unexpected version type in request from [" + operation.origin().name() + "] found [" + operation.versionType().name() + "] expected [" + operation.versionType().versionTypeForReplicationAndRecovery().name() + "]";
        return true;
    }

    private boolean assertIncomingSequenceNumber(Engine.Operation.Origin origin, long seqNo) {
        if (this.engineConfig.getIndexSettings().getIndexVersionCreated().before(Version.V_6_0_0_alpha1) && origin == Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY) {
            assert (seqNo == -2L) : "old op recovering but it already has a seq no.; index version: " + this.engineConfig.getIndexSettings().getIndexVersionCreated() + ", seqNo: " + seqNo;
        } else if (origin == Engine.Operation.Origin.PRIMARY) {
            assert (this.assertOriginPrimarySequenceNumber(seqNo));
        } else if (this.engineConfig.getIndexSettings().getIndexVersionCreated().onOrAfter(Version.V_6_0_0_alpha1)) assert (seqNo >= 0L) : "recovery or replica ops should have an assigned seq no.; origin: " + (Object)((Object)origin);
        return true;
    }

    protected boolean assertOriginPrimarySequenceNumber(long seqNo) {
        assert (seqNo == -2L) : "primary operations must never have an assigned sequence number but was [" + seqNo + "]";
        return true;
    }

    private boolean assertSequenceNumberBeforeIndexing(Engine.Operation.Origin origin, long seqNo) {
        if (this.engineConfig.getIndexSettings().getIndexVersionCreated().onOrAfter(Version.V_6_0_0_alpha1) || origin == Engine.Operation.Origin.PRIMARY) assert (seqNo >= 0L) : "ops should have an assigned seq no.; origin: " + (Object)((Object)origin);
        return true;
    }

    private long generateSeqNoForOperation(Engine.Operation operation) {
        assert (operation.origin() == Engine.Operation.Origin.PRIMARY);
        return this.doGenerateSeqNoForOperation(operation);
    }

    protected long doGenerateSeqNoForOperation(Engine.Operation operation) {
        return this.localCheckpointTracker.generateSeqNo();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Engine.IndexResult index(Engine.Index index) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IndexingStrategy planIndexingAsNonPrimary(Engine.Index index) throws IOException {
        IndexingStrategy plan;
        boolean appendOnlyRequest = this.canOptimizeAddDocument(index);
        if (appendOnlyRequest && !this.mayHaveBeenIndexedBefore(index) && index.seqNo() > this.maxSeqNoOfNonAppendOnlyOperations.get()) {
            assert (index.version() == 1L) : "can optimize on replicas but incoming version is [" + index.version() + "]";
            plan = IndexingStrategy.optimizedAppendOnly(index.seqNo());
        } else {
            OpVsLuceneDocStatus opVsLucene;
            if (!appendOnlyRequest) {
                this.maxSeqNoOfNonAppendOnlyOperations.updateAndGet(curr -> Math.max(index.seqNo(), curr));
                assert (this.maxSeqNoOfNonAppendOnlyOperations.get() >= index.seqNo()) : "max_seqno of non-append-only was not updated;max_seqno non-append-only [" + this.maxSeqNoOfNonAppendOnlyOperations.get() + "], seqno of index [" + index.seqNo() + "]";
            }
            this.versionMap.enforceSafeAccess();
            assert (index.versionType().versionTypeForReplicationAndRecovery() == index.versionType()) : "resolving out of order delivery based on versioning but version type isn't fit for it. got [" + index.versionType() + "]";
            if (index.seqNo() == -2L) {
                assert (this.config().getIndexSettings().getIndexVersionCreated().before(Version.V_6_0_0_alpha1)) : "index is newly created but op has no sequence numbers. op: " + index;
                opVsLucene = this.compareOpToLuceneDocBasedOnVersions(index);
            } else {
                opVsLucene = index.seqNo() <= this.localCheckpointTracker.getCheckpoint() ? OpVsLuceneDocStatus.OP_STALE_OR_EQUAL : this.compareOpToLuceneDocBasedOnSeqNo(index);
            }
            plan = opVsLucene == OpVsLuceneDocStatus.OP_STALE_OR_EQUAL ? IndexingStrategy.processButSkipLucene(false, index.seqNo(), index.version()) : IndexingStrategy.processNormally(opVsLucene == OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND, index.seqNo(), index.version());
        }
        return plan;
    }

    private IndexingStrategy planIndexingAsPrimary(Engine.Index index) throws IOException {
        IndexingStrategy plan;
        assert (index.origin() == Engine.Operation.Origin.PRIMARY) : "planing as primary but origin isn't. got " + (Object)((Object)index.origin());
        if (this.canOptimizeAddDocument(index)) {
            if (this.mayHaveBeenIndexedBefore(index)) {
                plan = IndexingStrategy.overrideExistingAsIfNotThere(this.generateSeqNoForOperation(index), 1L);
                this.versionMap.enforceSafeAccess();
            } else {
                plan = IndexingStrategy.optimizedAppendOnly(this.generateSeqNoForOperation(index));
            }
        } else {
            boolean currentNotFoundOrDeleted;
            long currentVersion;
            this.versionMap.enforceSafeAccess();
            VersionValue versionValue = this.resolveDocVersion(index);
            if (versionValue == null) {
                currentVersion = -1L;
                currentNotFoundOrDeleted = true;
            } else {
                currentVersion = versionValue.version;
                currentNotFoundOrDeleted = versionValue.isDelete();
            }
            if (index.versionType().isVersionConflictForWrites(currentVersion, index.version(), currentNotFoundOrDeleted)) {
                VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, index, currentVersion, currentNotFoundOrDeleted);
                plan = IndexingStrategy.skipDueToVersionConflict(e, currentNotFoundOrDeleted, currentVersion);
            } else {
                plan = IndexingStrategy.processNormally(currentNotFoundOrDeleted, this.generateSeqNoForOperation(index), index.versionType().updateVersion(currentVersion, index.version()));
            }
        }
        return plan;
    }

    private Engine.IndexResult indexIntoLucene(Engine.Index index, IndexingStrategy plan) throws IOException {
        assert (this.assertSequenceNumberBeforeIndexing(index.origin(), plan.seqNoForIndexing));
        assert (plan.versionForIndexing >= 0L) : "version must be set. got " + plan.versionForIndexing;
        assert (plan.indexIntoLucene);
        index.parsedDoc().updateSeqID(plan.seqNoForIndexing, index.primaryTerm());
        index.parsedDoc().version().setLongValue(plan.versionForIndexing);
        try {
            if (plan.useLuceneUpdateDocument) {
                this.updateDocs(index.uid(), index.docs(), this.indexWriter);
            } else {
                assert (this.assertDocDoesNotExist(index, !this.canOptimizeAddDocument(index)));
                this.addDocs(index.docs(), this.indexWriter);
            }
            return new Engine.IndexResult(plan.versionForIndexing, plan.seqNoForIndexing, plan.currentNotFoundOrDeleted);
        }
        catch (Exception ex) {
            if (this.indexWriter.getTragicException() == null) {
                return new Engine.IndexResult(ex, -3L, plan.seqNoForIndexing);
            }
            throw ex;
        }
    }

    private boolean mayHaveBeenIndexedBefore(Engine.Index index) {
        boolean mayHaveBeenIndexBefore;
        assert (this.canOptimizeAddDocument(index));
        if (index.isRetry()) {
            mayHaveBeenIndexBefore = true;
            this.maxUnsafeAutoIdTimestamp.updateAndGet(curr -> Math.max(index.getAutoGeneratedIdTimestamp(), curr));
            assert (this.maxUnsafeAutoIdTimestamp.get() >= index.getAutoGeneratedIdTimestamp());
        } else {
            mayHaveBeenIndexBefore = this.maxUnsafeAutoIdTimestamp.get() >= index.getAutoGeneratedIdTimestamp();
        }
        return mayHaveBeenIndexBefore;
    }

    long getMaxSeqNoOfNonAppendOnlyOperations() {
        return this.maxSeqNoOfNonAppendOnlyOperations.get();
    }

    private void addDocs(List<ParseContext.Document> docs, IndexWriter indexWriter) throws IOException {
        if (docs.size() > 1) {
            indexWriter.addDocuments(docs);
        } else {
            indexWriter.addDocument(docs.get(0));
        }
        this.numDocAppends.inc(docs.size());
    }

    private boolean assertDocDoesNotExist(Engine.Index index, boolean allowDeleted) throws IOException {
        VersionValue versionValue = this.versionMap.getVersionForAssert(index.uid().bytes());
        if (versionValue != null) {
            if (!versionValue.isDelete() || !allowDeleted) {
                throw new AssertionError((Object)("doc [" + index.type() + "][" + index.id() + "] exists in version map (version " + versionValue + ")"));
            }
        } else {
            try (Engine.Searcher searcher = this.acquireSearcher("assert doc doesn't exist", Engine.SearcherScope.INTERNAL);){
                long docsWithId = searcher.searcher().count(new TermQuery(index.uid()));
                if (docsWithId > 0L) {
                    throw new AssertionError((Object)("doc [" + index.type() + "][" + index.id() + "] exists [" + docsWithId + "] times in index"));
                }
            }
        }
        return true;
    }

    private void updateDocs(Term uid, List<ParseContext.Document> docs, IndexWriter indexWriter) throws IOException {
        if (docs.size() > 1) {
            indexWriter.updateDocuments(uid, docs);
        } else {
            indexWriter.updateDocument(uid, docs.get(0));
        }
        this.numDocUpdates.inc(docs.size());
    }

    @Override
    public Engine.DeleteResult delete(Engine.Delete delete) throws IOException {
        Engine.DeleteResult deleteResult;
        this.versionMap.enforceSafeAccess();
        assert (Objects.equals(delete.uid().field(), this.uidField)) : delete.uid().field();
        assert (this.assertVersionType(delete));
        assert (this.assertIncomingSequenceNumber(delete.origin(), delete.seqNo()));
        try (ReleasableLock ignored = this.readLock.acquire();
             Releasable ignored2 = this.versionMap.acquireLock(delete.uid().bytes());){
            this.ensureOpen();
            this.lastWriteNanos = delete.startTime();
            DeletionStrategy plan = delete.origin() == Engine.Operation.Origin.PRIMARY ? this.planDeletionAsPrimary(delete) : this.planDeletionAsNonPrimary(delete);
            deleteResult = plan.earlyResultOnPreflightError.isPresent() ? plan.earlyResultOnPreflightError.get() : (plan.deleteFromLucene ? this.deleteInLucene(delete, plan) : new Engine.DeleteResult(plan.versionOfDeletion, plan.seqNoOfDeletion, !plan.currentlyDeleted));
            if (delete.origin() != Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY) {
                Translog.Location location = deleteResult.getResultType() == Engine.Result.Type.SUCCESS ? this.translog.add(new Translog.Delete(delete, deleteResult)) : (deleteResult.getSeqNo() != -2L ? this.translog.add(new Translog.NoOp(deleteResult.getSeqNo(), delete.primaryTerm(), deleteResult.getFailure().getMessage())) : null);
                deleteResult.setTranslogLocation(location);
            }
            if (deleteResult.getSeqNo() != -2L) {
                this.localCheckpointTracker.markSeqNoAsCompleted(deleteResult.getSeqNo());
            }
            deleteResult.setTook(System.nanoTime() - delete.startTime());
            deleteResult.freeze();
        }
        catch (IOException | RuntimeException e) {
            try {
                this.maybeFailEngine("index", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        this.maybePruneDeletes();
        return deleteResult;
    }

    private DeletionStrategy planDeletionAsNonPrimary(Engine.Delete delete) throws IOException {
        OpVsLuceneDocStatus opVsLucene;
        assert (delete.origin() != Engine.Operation.Origin.PRIMARY) : "planing as primary but got " + (Object)((Object)delete.origin());
        assert (delete.versionType().versionTypeForReplicationAndRecovery() == delete.versionType()) : "resolving out of order delivery based on versioning but version type isn't fit for it. got [" + delete.versionType() + "]";
        this.maxSeqNoOfNonAppendOnlyOperations.updateAndGet(curr -> Math.max(delete.seqNo(), curr));
        assert (this.maxSeqNoOfNonAppendOnlyOperations.get() >= delete.seqNo()) : "max_seqno of non-append-only was not updated;max_seqno non-append-only [" + this.maxSeqNoOfNonAppendOnlyOperations.get() + "], seqno of delete [" + delete.seqNo() + "]";
        if (delete.seqNo() == -2L) {
            assert (this.config().getIndexSettings().getIndexVersionCreated().before(Version.V_6_0_0_alpha1)) : "index is newly created but op has no sequence numbers. op: " + delete;
            opVsLucene = this.compareOpToLuceneDocBasedOnVersions(delete);
        } else {
            opVsLucene = delete.seqNo() <= this.localCheckpointTracker.getCheckpoint() ? OpVsLuceneDocStatus.OP_STALE_OR_EQUAL : this.compareOpToLuceneDocBasedOnSeqNo(delete);
        }
        DeletionStrategy plan = opVsLucene == OpVsLuceneDocStatus.OP_STALE_OR_EQUAL ? DeletionStrategy.processButSkipLucene(false, delete.seqNo(), delete.version()) : DeletionStrategy.processNormally(opVsLucene == OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND, delete.seqNo(), delete.version());
        return plan;
    }

    private DeletionStrategy planDeletionAsPrimary(Engine.Delete delete) throws IOException {
        DeletionStrategy plan;
        boolean currentlyDeleted;
        long currentVersion;
        assert (delete.origin() == Engine.Operation.Origin.PRIMARY) : "planing as primary but got " + (Object)((Object)delete.origin());
        VersionValue versionValue = this.resolveDocVersion(delete);
        assert (this.incrementVersionLookup());
        if (versionValue == null) {
            currentVersion = -1L;
            currentlyDeleted = true;
        } else {
            currentVersion = versionValue.version;
            currentlyDeleted = versionValue.isDelete();
        }
        if (delete.versionType().isVersionConflictForWrites(currentVersion, delete.version(), currentlyDeleted)) {
            VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, delete, currentVersion, currentlyDeleted);
            plan = DeletionStrategy.skipDueToVersionConflict(e, currentVersion, currentlyDeleted);
        } else {
            plan = DeletionStrategy.processNormally(currentlyDeleted, this.generateSeqNoForOperation(delete), delete.versionType().updateVersion(currentVersion, delete.version()));
        }
        return plan;
    }

    private Engine.DeleteResult deleteInLucene(Engine.Delete delete, DeletionStrategy plan) throws IOException {
        try {
            if (!plan.currentlyDeleted) {
                this.indexWriter.deleteDocuments(delete.uid());
                this.numDocDeletes.inc();
            }
            this.versionMap.putDeleteUnderLock(delete.uid().bytes(), new DeleteVersionValue(plan.versionOfDeletion, plan.seqNoOfDeletion, delete.primaryTerm(), this.engineConfig.getThreadPool().relativeTimeInMillis()));
            return new Engine.DeleteResult(plan.versionOfDeletion, plan.seqNoOfDeletion, !plan.currentlyDeleted);
        }
        catch (Exception ex) {
            if (this.indexWriter.getTragicException() == null) {
                return new Engine.DeleteResult(ex, plan.versionOfDeletion, plan.seqNoOfDeletion, !plan.currentlyDeleted);
            }
            throw ex;
        }
    }

    @Override
    public void maybePruneDeletes() {
        if (this.engineConfig.isEnableGcDeletes() && (double)(this.engineConfig.getThreadPool().relativeTimeInMillis() - this.lastDeleteVersionPruneTimeMSec) > (double)this.getGcDeletesInMillis() * 0.25) {
            this.pruneDeletedTombstones();
        }
    }

    @Override
    public Engine.NoOpResult noOp(Engine.NoOp noOp) {
        Engine.NoOpResult noOpResult;
        try (ReleasableLock ignored = this.readLock.acquire();){
            noOpResult = this.innerNoOp(noOp);
        }
        catch (Exception e) {
            noOpResult = new Engine.NoOpResult(noOp.seqNo(), e);
        }
        return noOpResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Engine.NoOpResult innerNoOp(Engine.NoOp noOp) throws IOException {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread());
        assert (noOp.seqNo() > -1L);
        long seqNo = noOp.seqNo();
        try {
            Engine.NoOpResult noOpResult = new Engine.NoOpResult(noOp.seqNo());
            Translog.Location location = this.translog.add(new Translog.NoOp(noOp.seqNo(), noOp.primaryTerm(), noOp.reason()));
            noOpResult.setTranslogLocation(location);
            noOpResult.setTook(System.nanoTime() - noOp.startTime());
            noOpResult.freeze();
            Engine.NoOpResult noOpResult2 = noOpResult;
            return noOpResult2;
        }
        finally {
            if (seqNo != -2L) {
                this.localCheckpointTracker.markSeqNoAsCompleted(seqNo);
            }
        }
    }

    @Override
    public void refresh(String source) throws EngineException {
        this.refresh(source, Engine.SearcherScope.EXTERNAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final void refresh(String source, Engine.SearcherScope scope) throws EngineException {
        block21: {
            bytes = this.indexWriter.ramBytesUsed() + this.versionMap.ramBytesUsedForRefresh();
            this.writingBytes.addAndGet(bytes);
            try {
                lock = this.readLock.acquire();
                var6_7 = null;
                try {
                    this.ensureOpen();
                    if (!this.store.tryIncRef()) break block21;
                    try {
                        switch (1.$SwitchMap$org$elasticsearch$index$engine$Engine$SearcherScope[scope.ordinal()]) {
                            case 1: {
                                this.externalSearcherManager.maybeRefreshBlocking();
                                ** break;
lbl15:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                this.internalSearcherManager.maybeRefreshBlocking();
                                ** break;
lbl19:
                                // 1 sources

                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("unknown scope: " + (Object)scope);
                            }
                        }
                    }
                    finally {
                        this.store.decRef();
                    }
                }
                catch (Throwable var7_10) {
                    var6_7 = var7_10;
                    throw var7_10;
                }
                finally {
                    if (lock != null) {
                        InternalEngine.$closeResource(var6_7, lock);
                    }
                }
            }
            catch (AlreadyClosedException e) {
                this.failOnTragicEvent(e);
                throw e;
            }
            catch (Exception e) {
                try {
                    this.failEngine("refresh failed source[" + source + "]", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
            }
            finally {
                this.writingBytes.addAndGet(-bytes);
            }
        }
        this.maybePruneDeletes();
        this.mergeScheduler.refreshConfig();
    }

    @Override
    public void writeIndexingBuffer() throws EngineException {
        this.refresh("write indexing buffer", Engine.SearcherScope.INTERNAL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) throws EngineException {
        this.ensureOpen();
        if (this.indexWriter.hasUncommittedChanges()) {
            this.logger.trace("can't sync commit [{}]. have pending changes", (Object)syncId);
            return Engine.SyncedFlushResult.PENDING_OPERATIONS;
        }
        if (!expectedCommitId.idsEqual(this.lastCommittedSegmentInfos.getId())) {
            this.logger.trace("can't sync commit [{}]. current commit id is not equal to expected.", (Object)syncId);
            return Engine.SyncedFlushResult.COMMIT_MISMATCH;
        }
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            this.ensureCanFlush();
            this.refresh("sync_flush", Engine.SearcherScope.INTERNAL);
            if (this.indexWriter.hasUncommittedChanges()) {
                this.logger.trace("can't sync commit [{}]. have pending changes", (Object)syncId);
                Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.PENDING_OPERATIONS;
                return syncedFlushResult;
            }
            if (!expectedCommitId.idsEqual(this.lastCommittedSegmentInfos.getId())) {
                this.logger.trace("can't sync commit [{}]. current commit id is not equal to expected.", (Object)syncId);
                Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.COMMIT_MISMATCH;
                return syncedFlushResult;
            }
            this.logger.trace("starting sync commit [{}]", (Object)syncId);
            this.commitIndexWriter(this.indexWriter, this.translog, syncId);
            this.logger.debug("successfully sync committed. sync id [{}].", (Object)syncId);
            this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
            Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.SUCCESS;
            return syncedFlushResult;
        }
        catch (IOException ex) {
            this.maybeFailEngine("sync commit", ex);
            throw new EngineException(this.shardId, "failed to sync commit", ex, new Object[0]);
        }
    }

    final boolean tryRenewSyncCommit() {
        boolean renewed = false;
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            this.ensureCanFlush();
            String syncId = this.lastCommittedSegmentInfos.getUserData().get("sync_id");
            long translogGenOfLastCommit = Long.parseLong(this.lastCommittedSegmentInfos.userData.get("translog_generation"));
            if (syncId != null && this.indexWriter.hasUncommittedChanges() && this.translog.totalOperationsByMinGen(translogGenOfLastCommit) == 0) {
                this.logger.trace("start renewing sync commit [{}]", (Object)syncId);
                this.commitIndexWriter(this.indexWriter, this.translog, syncId);
                this.logger.debug("successfully sync committed. sync id [{}].", (Object)syncId);
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                renewed = true;
            }
        }
        catch (IOException ex) {
            this.maybeFailEngine("renew sync commit", ex);
            throw new EngineException(this.shardId, "failed to renew sync commit", ex, new Object[0]);
        }
        if (renewed) {
            this.refresh("renew sync commit", Engine.SearcherScope.INTERNAL);
        }
        return renewed;
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        this.ensureOpen();
        long translogGenerationOfLastCommit = Long.parseLong(this.lastCommittedSegmentInfos.userData.get("translog_generation"));
        long flushThreshold = this.config().getIndexSettings().getFlushThresholdSize().getBytes();
        if (this.translog.sizeInBytesByMinGen(translogGenerationOfLastCommit) < flushThreshold) {
            return false;
        }
        long translogGenerationOfNewCommit = this.translog.getMinGenerationForSeqNo((long)(this.localCheckpointTracker.getCheckpoint() + 1L)).translogFileGeneration;
        return translogGenerationOfLastCommit < translogGenerationOfNewCommit || this.localCheckpointTracker.getCheckpoint() == this.localCheckpointTracker.getMaxSeqNo();
    }

    @Override
    public Engine.CommitId flush() throws EngineException {
        return this.flush(false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Engine.CommitId flush(boolean force, boolean waitIfOngoing) throws EngineException {
        byte[] newCommitId;
        this.ensureOpen();
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            if (!this.flushLock.tryLock()) {
                if (!waitIfOngoing) {
                    Engine.CommitId commitId = new Engine.CommitId(this.lastCommittedSegmentInfos.getId());
                    return commitId;
                }
                this.logger.trace("waiting for in-flight flush to finish");
                this.flushLock.lock();
                this.logger.trace("acquired flush lock after blocking");
            } else {
                this.logger.trace("acquired flush lock immediately");
            }
            try {
                if (this.indexWriter.hasUncommittedChanges() || force || this.shouldPeriodicallyFlush()) {
                    this.ensureCanFlush();
                    try {
                        this.translog.rollGeneration();
                        this.logger.trace("starting commit for flush; commitTranslog=true");
                        this.commitIndexWriter(this.indexWriter, this.translog, null);
                        this.logger.trace("finished commit for flush");
                        this.refresh("version_table_flush", Engine.SearcherScope.INTERNAL);
                        this.translog.trimUnreferencedReaders();
                    }
                    catch (AlreadyClosedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                    this.refreshLastCommittedSegmentInfos();
                }
                newCommitId = this.lastCommittedSegmentInfos.getId();
            }
            catch (FlushFailedEngineException ex) {
                this.maybeFailEngine("flush", ex);
                throw ex;
            }
            finally {
                this.flushLock.unlock();
            }
        }
        if (!this.engineConfig.isEnableGcDeletes()) return new Engine.CommitId(newCommitId);
        this.pruneDeletedTombstones();
        return new Engine.CommitId(newCommitId);
    }

    private void refreshLastCommittedSegmentInfos() {
        block8: {
            this.store.incRef();
            try {
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
            }
            catch (Exception e) {
                if (this.isClosed.get()) break block8;
                try {
                    this.logger.warn("failed to read latest segment infos on flush", (Throwable)e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                if (Lucene.isCorruptionException(e)) {
                    throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                }
            }
            finally {
                this.store.decRef();
            }
        }
    }

    @Override
    public void rollTranslogGeneration() throws EngineException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            this.translog.rollGeneration();
            this.translog.trimUnreferencedReaders();
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("translog trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new EngineException(this.shardId, "failed to roll translog", e, new Object[0]);
        }
    }

    @Override
    public void trimTranslog() throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.translog.trimUnreferencedReaders();
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("translog trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new EngineException(this.shardId, "failed to trim translog", e, new Object[0]);
        }
    }

    private void pruneDeletedTombstones() {
        long timeMSec = this.engineConfig.getThreadPool().relativeTimeInMillis();
        long maxTimestampToPrune = timeMSec - this.engineConfig.getIndexSettings().getGcDeletesInMillis();
        this.versionMap.pruneTombstones(maxTimestampToPrune, this.localCheckpointTracker.getCheckpoint());
        this.lastDeleteVersionPruneTimeMSec = timeMSec;
    }

    void clearDeletedTombstones() {
        this.versionMap.pruneTombstones(Long.MAX_VALUE, this.localCheckpointTracker.getMaxSeqNo());
    }

    final Collection<DeleteVersionValue> getDeletedTombstones() {
        return this.versionMap.getAllTombstones().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments) throws EngineException, IOException {
        assert (this.indexWriter.getConfig().getMergePolicy() instanceof ElasticsearchMergePolicy) : "MergePolicy is " + this.indexWriter.getConfig().getMergePolicy().getClass().getName();
        ElasticsearchMergePolicy mp = (ElasticsearchMergePolicy)this.indexWriter.getConfig().getMergePolicy();
        this.optimizeLock.lock();
        try {
            this.ensureOpen();
            if (upgrade) {
                this.logger.info("starting segment upgrade upgradeOnlyAncientSegments={}", (Object)upgradeOnlyAncientSegments);
                mp.setUpgradeInProgress(true, upgradeOnlyAncientSegments);
            }
            this.store.incRef();
            try {
                if (onlyExpungeDeletes) {
                    assert (!upgrade);
                    this.indexWriter.forceMergeDeletes(true);
                } else if (maxNumSegments <= 0) {
                    assert (!upgrade);
                    this.indexWriter.maybeMerge();
                } else {
                    this.indexWriter.forceMerge(maxNumSegments, true);
                }
                if (flush && !this.tryRenewSyncCommit()) {
                    this.flush(false, true);
                }
                if (upgrade) {
                    this.logger.info("finished segment upgrade");
                }
            }
            finally {
                this.store.decRef();
            }
        }
        catch (AlreadyClosedException ex) {
            this.ensureOpen(ex);
            this.failOnTragicEvent(ex);
            throw ex;
        }
        catch (Exception e) {
            try {
                this.maybeFailEngine("force merge", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        finally {
            try {
                mp.setUpgradeInProgress(false, false);
            }
            finally {
                this.optimizeLock.unlock();
            }
        }
    }

    @Override
    public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        if (flushFirst) {
            this.logger.trace("start flush for snapshot");
            this.flush(false, true);
            this.logger.trace("finish flush for snapshot");
        }
        IndexCommit lastCommit = this.combinedDeletionPolicy.acquireIndexCommit(false);
        return new Engine.IndexCommitRef(lastCommit, () -> this.releaseIndexCommit(lastCommit));
    }

    @Override
    public Engine.IndexCommitRef acquireSafeIndexCommit() throws EngineException {
        IndexCommit safeCommit = this.combinedDeletionPolicy.acquireIndexCommit(true);
        return new Engine.IndexCommitRef(safeCommit, () -> this.releaseIndexCommit(safeCommit));
    }

    private void releaseIndexCommit(IndexCommit snapshot) throws IOException {
        if (this.combinedDeletionPolicy.releaseCommit(snapshot)) {
            this.ensureOpen();
            this.indexWriter.deleteUnusedFiles();
        }
    }

    private boolean failOnTragicEvent(AlreadyClosedException ex) {
        boolean engineFailed;
        if (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() != null) {
            Exception tragicException = this.indexWriter.getTragicException() instanceof Exception ? (Exception)this.indexWriter.getTragicException() : new RuntimeException(this.indexWriter.getTragicException());
            this.failEngine("already closed by tragic event on the index writer", tragicException);
            engineFailed = true;
        } else if (!this.translog.isOpen() && this.translog.getTragicException() != null) {
            this.failEngine("already closed by tragic event on the translog", this.translog.getTragicException());
            engineFailed = true;
        } else {
            if (this.failedEngine.get() == null && !this.isClosed.get()) {
                throw new AssertionError("Unexpected AlreadyClosedException", ex);
            }
            engineFailed = false;
        }
        return engineFailed;
    }

    @Override
    protected boolean maybeFailEngine(String source, Exception e) {
        boolean shouldFail = super.maybeFailEngine(source, e);
        if (shouldFail) {
            return true;
        }
        if (e instanceof AlreadyClosedException) {
            return this.failOnTragicEvent((AlreadyClosedException)e);
        }
        if (e != null && (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() == e || !this.translog.isOpen() && this.translog.getTragicException() == e)) {
            this.failEngine(source, e);
            return true;
        }
        return false;
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    protected final void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(this.versionMap.ramBytesUsed());
        stats.addIndexWriterMemoryInBytes(this.indexWriter.ramBytesUsed());
        stats.updateMaxUnsafeAutoIdTimestamp(this.maxUnsafeAutoIdTimestamp.get());
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return this.indexWriter.ramBytesUsed() + this.versionMap.ramBytesUsedForRefresh();
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        try (ReleasableLock lock = this.readLock.acquire();){
            Segment[] segmentsArr = this.getSegmentInfo(this.lastCommittedSegmentInfos, verbose);
            Set<OnGoingMerge> onGoingMerges = this.mergeScheduler.onGoingMerges();
            for (OnGoingMerge onGoingMerge : onGoingMerges) {
                block6: for (SegmentCommitInfo segmentInfoPerCommit : onGoingMerge.getMergedSegments()) {
                    for (Segment segment : segmentsArr) {
                        if (!segment.getName().equals(segmentInfoPerCommit.info.name)) continue;
                        segment.mergeId = onGoingMerge.getId();
                        continue block6;
                    }
                }
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            assert (this.rwl.isWriteLockedByCurrentThread() || this.failEngineLock.isHeldByCurrentThread()) : "Either the write lock must be held or the engine must be currently be failing itself";
            try {
                this.versionMap.clear();
                if (this.internalSearcherManager != null) {
                    this.internalSearcherManager.removeListener(this.versionMap);
                }
                try {
                    IOUtils.close(this.externalSearcherManager, this.internalSearcherManager);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to close SearcherManager", (Throwable)e);
                }
                try {
                    IOUtils.close(this.translog);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to close translog", (Throwable)e);
                }
                this.logger.trace("rollback indexWriter");
                try {
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException ex) {
                    this.failOnTragicEvent(ex);
                    throw ex;
                }
                this.logger.trace("rollback indexWriter done");
            }
            catch (Exception e) {
                this.logger.warn("failed to rollback writer on close", (Throwable)e);
            }
            finally {
                try {
                    this.store.decRef();
                    this.logger.debug("engine closed [{}]", (Object)reason);
                }
                finally {
                    closedLatch.countDown();
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Engine.Searcher acquireSearcher(String source, Engine.SearcherScope scope) {
        EngineSearcher engineSearcher;
        this.store.incRef();
        Releasable releasable = this.store::decRef;
        try {
            ReferenceManager referenceManager;
            switch (scope) {
                case INTERNAL: {
                    referenceManager = this.internalSearcherManager;
                    break;
                }
                case EXTERNAL: {
                    referenceManager = this.externalSearcherManager;
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown scope: " + (Object)((Object)scope));
                }
            }
            EngineSearcher engineSearcher2 = new EngineSearcher(source, referenceManager, this.store, this.logger);
            releasable = null;
            engineSearcher = engineSearcher2;
        }
        catch (AlreadyClosedException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    this.ensureOpen(ex2);
                    this.logger.error(() -> new ParameterizedMessage("failed to acquire searcher, source {}", (Object)source), (Throwable)ex2);
                    throw new EngineException(this.shardId, "failed to acquire searcher, source " + source, ex2, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                Releasables.close(releasable);
                throw throwable;
            }
        }
        Releasables.close(releasable);
        return engineSearcher;
    }

    private long loadCurrentVersionFromIndex(Term uid) throws IOException {
        assert (this.incrementIndexVersionLookup());
        try (Engine.Searcher searcher = this.acquireSearcher("load_version", Engine.SearcherScope.INTERNAL);){
            long l = VersionsAndSeqNoResolver.loadVersion(searcher.reader(), uid);
            return l;
        }
    }

    private IndexWriter createWriter() throws IOException {
        try {
            IndexWriterConfig iwc = this.getIndexWriterConfig();
            return this.createWriter(this.store.directory(), iwc);
        }
        catch (LockObtainFailedException ex) {
            this.logger.warn("could not lock IndexWriter", (Throwable)ex);
            throw ex;
        }
    }

    IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
        return new IndexWriter(directory, iwc);
    }

    private IndexWriterConfig getIndexWriterConfig() {
        IndexWriterConfig iwc = new IndexWriterConfig(this.engineConfig.getAnalyzer());
        iwc.setCommitOnClose(false);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        iwc.setIndexDeletionPolicy(this.combinedDeletionPolicy);
        boolean verbose = false;
        try {
            verbose = Boolean.parseBoolean(System.getProperty("tests.verbose"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        iwc.setInfoStream(verbose ? InfoStream.getDefault() : new LoggerInfoStream(this.logger));
        iwc.setMergeScheduler(this.mergeScheduler);
        MergePolicy mergePolicy = this.config().getMergePolicy();
        mergePolicy = new ElasticsearchMergePolicy(mergePolicy);
        iwc.setMergePolicy(mergePolicy);
        iwc.setSimilarity(this.engineConfig.getSimilarity());
        iwc.setRAMBufferSizeMB(this.engineConfig.getIndexingBufferSize().getMbFrac());
        iwc.setCodec(this.engineConfig.getCodec());
        iwc.setUseCompoundFile(true);
        if (this.config().getIndexSort() != null) {
            iwc.setIndexSort(this.config().getIndexSort());
        }
        return iwc;
    }

    @Override
    public void activateThrottling() {
        int count = this.throttleRequestCount.incrementAndGet();
        assert (count >= 1) : "invalid post-increment throttleRequestCount=" + count;
        if (count == 1) {
            this.throttle.activate();
        }
    }

    @Override
    public void deactivateThrottling() {
        int count = this.throttleRequestCount.decrementAndGet();
        assert (count >= 0) : "invalid post-decrement throttleRequestCount=" + count;
        if (count == 0) {
            this.throttle.deactivate();
        }
    }

    @Override
    public boolean isThrottled() {
        return this.throttle.isThrottled();
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return this.throttle.getThrottleTimeInMillis();
    }

    long getGcDeletesInMillis() {
        return this.engineConfig.getIndexSettings().getGcDeletesInMillis();
    }

    LiveIndexWriterConfig getCurrentIndexWriterConfig() {
        return this.indexWriter.getConfig();
    }

    protected void commitIndexWriter(IndexWriter writer, Translog translog, @Nullable String syncId) throws IOException {
        this.ensureCanFlush();
        try {
            long localCheckpoint = this.localCheckpointTracker.getCheckpoint();
            Translog.TranslogGeneration translogGeneration = translog.getMinGenerationForSeqNo(localCheckpoint + 1L);
            String translogFileGeneration = Long.toString(translogGeneration.translogFileGeneration);
            String translogUUID = translogGeneration.translogUUID;
            String localCheckpointValue = Long.toString(localCheckpoint);
            writer.setLiveCommitData(() -> {
                HashMap<String, String> commitData = new HashMap<String, String>(6);
                commitData.put("translog_generation", translogFileGeneration);
                commitData.put("translog_uuid", translogUUID);
                commitData.put("local_checkpoint", localCheckpointValue);
                if (syncId != null) {
                    commitData.put("sync_id", syncId);
                }
                commitData.put("max_seq_no", Long.toString(this.localCheckpointTracker.getMaxSeqNo()));
                commitData.put(MAX_UNSAFE_AUTO_ID_TIMESTAMP_COMMIT_ID, Long.toString(this.maxUnsafeAutoIdTimestamp.get()));
                commitData.put("history_uuid", this.historyUUID);
                this.logger.trace("committing writer with commit data [{}]", commitData);
                return commitData.entrySet().iterator();
            });
            writer.commit();
        }
        catch (Exception ex) {
            try {
                this.failEngine("lucene commit failed", ex);
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
        catch (AssertionError e) {
            if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexWriter.filesExist")) {
                EngineException engineException = new EngineException(this.shardId, "failed to commit engine", (Throwable)((Object)e), new Object[0]);
                try {
                    this.failEngine("lucene commit failed", engineException);
                }
                catch (Exception inner) {
                    engineException.addSuppressed(inner);
                }
                throw engineException;
            }
            throw e;
        }
    }

    private void ensureCanFlush() {
        if (this.pendingTranslogRecovery.get()) {
            throw new IllegalStateException(this.shardId.toString() + " flushes are disabled - pending translog recovery");
        }
    }

    @Override
    public void onSettingsChanged() {
        this.mergeScheduler.refreshConfig();
        this.maybePruneDeletes();
        if (!this.engineConfig.isAutoGeneratedIDsOptimizationEnabled()) {
            this.maxUnsafeAutoIdTimestamp.set(Long.MAX_VALUE);
        }
        TranslogDeletionPolicy translogDeletionPolicy = this.translog.getDeletionPolicy();
        IndexSettings indexSettings = this.engineConfig.getIndexSettings();
        translogDeletionPolicy.setRetentionAgeInMillis(indexSettings.getTranslogRetentionAge().getMillis());
        translogDeletionPolicy.setRetentionSizeInBytes(indexSettings.getTranslogRetentionSize().getBytes());
    }

    @Override
    public MergeStats getMergeStats() {
        return this.mergeScheduler.stats();
    }

    @Override
    public final LocalCheckpointTracker getLocalCheckpointTracker() {
        return this.localCheckpointTracker;
    }

    long getNumIndexVersionsLookups() {
        return this.numIndexVersionsLookups.count();
    }

    long getNumVersionLookups() {
        return this.numVersionLookups.count();
    }

    private boolean incrementVersionLookup() {
        this.numVersionLookups.inc();
        return true;
    }

    private boolean incrementIndexVersionLookup() {
        this.numIndexVersionsLookups.inc();
        return true;
    }

    int getVersionMapSize() {
        return this.versionMap.getAllCurrent().size();
    }

    boolean isSafeAccessRequired() {
        return this.versionMap.isSafeAccessRequired();
    }

    long getNumDocDeletes() {
        return this.numDocDeletes.count();
    }

    long getNumDocAppends() {
        return this.numDocAppends.count();
    }

    long getNumDocUpdates() {
        return this.numDocUpdates.count();
    }

    @Override
    public boolean isRecovering() {
        return this.pendingTranslogRecovery.get();
    }

    private static Map<String, String> commitDataAsMap(IndexWriter indexWriter) {
        HashMap<String, String> commitData = new HashMap<String, String>(6);
        for (Map.Entry<String, String> entry : indexWriter.getLiveCommitData()) {
            commitData.put(entry.getKey(), entry.getValue());
        }
        return commitData;
    }

    private static /* synthetic */ void lambda$index$0() {
    }

    private final class EngineMergeScheduler
    extends ElasticsearchConcurrentMergeScheduler {
        private final AtomicInteger numMergesInFlight;
        private final AtomicBoolean isThrottling;

        EngineMergeScheduler(ShardId shardId, IndexSettings indexSettings) {
            super(shardId, indexSettings);
            this.numMergesInFlight = new AtomicInteger(0);
            this.isThrottling = new AtomicBoolean();
        }

        @Override
        public synchronized void beforeMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMergeCount();
            if (this.numMergesInFlight.incrementAndGet() > maxNumMerges && !this.isThrottling.getAndSet(true)) {
                this.logger.info("now throttling indexing: numMergesInFlight={}, maxNumMerges={}", (Object)this.numMergesInFlight, (Object)maxNumMerges);
                InternalEngine.this.activateThrottling();
            }
        }

        @Override
        public synchronized void afterMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMergeCount();
            if (this.numMergesInFlight.decrementAndGet() < maxNumMerges && this.isThrottling.getAndSet(false)) {
                this.logger.info("stop throttling indexing: numMergesInFlight={}, maxNumMerges={}", (Object)this.numMergesInFlight, (Object)maxNumMerges);
                InternalEngine.this.deactivateThrottling();
            }
            if (!InternalEngine.this.indexWriter.hasPendingMerges() && System.nanoTime() - InternalEngine.this.lastWriteNanos >= InternalEngine.this.engineConfig.getFlushMergesAfter().nanos()) {
                InternalEngine.this.engineConfig.getThreadPool().executor("flush").execute(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (!InternalEngine.this.isClosed.get()) {
                            EngineMergeScheduler.this.logger.warn("failed to flush after merge has finished");
                        }
                    }

                    @Override
                    protected void doRun() throws Exception {
                        if (!InternalEngine.this.tryRenewSyncCommit()) {
                            InternalEngine.this.flush();
                        }
                    }
                });
            }
        }

        @Override
        protected void handleMergeException(final Directory dir, final Throwable exc) {
            InternalEngine.this.engineConfig.getThreadPool().generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    EngineMergeScheduler.this.logger.debug("merge failure action rejected", (Throwable)e);
                }

                @Override
                protected void doRun() throws Exception {
                    InternalEngine.this.failEngine("merge failed", new MergePolicy.MergeException(exc, dir));
                }
            });
        }
    }

    static final class SearchFactory
    extends EngineSearcherFactory {
        private final Engine.Warmer warmer;
        private final Logger logger;
        private final AtomicBoolean isEngineClosed;

        SearchFactory(Logger logger, AtomicBoolean isEngineClosed, EngineConfig engineConfig) {
            super(engineConfig);
            this.warmer = engineConfig.getWarmer();
            this.logger = logger;
            this.isEngineClosed = isEngineClosed;
        }

        @Override
        public IndexSearcher newSearcher(IndexReader reader, IndexReader previousReader) throws IOException {
            IndexSearcher searcher;
            block5: {
                searcher = super.newSearcher(reader, previousReader);
                if (reader instanceof LeafReader && Engine.isMergedSegment((LeafReader)reader)) {
                    return searcher;
                }
                if (this.warmer != null) {
                    try {
                        assert (searcher.getIndexReader() instanceof ElasticsearchDirectoryReader) : "this class needs an ElasticsearchDirectoryReader but got: " + searcher.getIndexReader().getClass();
                        this.warmer.warm(new Engine.Searcher("top_reader_warming", searcher));
                    }
                    catch (Exception e) {
                        if (this.isEngineClosed.get()) break block5;
                        this.logger.warn("failed to prepare/warm", (Throwable)e);
                    }
                }
            }
            return searcher;
        }
    }

    private static final class DeletionStrategy {
        final boolean deleteFromLucene;
        final boolean currentlyDeleted;
        final long seqNoOfDeletion;
        final long versionOfDeletion;
        final Optional<Engine.DeleteResult> earlyResultOnPreflightError;

        private DeletionStrategy(boolean deleteFromLucene, boolean currentlyDeleted, long seqNoOfDeletion, long versionOfDeletion, Engine.DeleteResult earlyResultOnPreflightError) {
            assert (!(deleteFromLucene && earlyResultOnPreflightError != null)) : "can only delete from lucene or have a preflight result but not both.deleteFromLucene: " + deleteFromLucene + "  earlyResultOnPreFlightError:" + earlyResultOnPreflightError;
            this.deleteFromLucene = deleteFromLucene;
            this.currentlyDeleted = currentlyDeleted;
            this.seqNoOfDeletion = seqNoOfDeletion;
            this.versionOfDeletion = versionOfDeletion;
            this.earlyResultOnPreflightError = earlyResultOnPreflightError == null ? Optional.empty() : Optional.of(earlyResultOnPreflightError);
        }

        static DeletionStrategy skipDueToVersionConflict(VersionConflictEngineException e, long currentVersion, boolean currentlyDeleted) {
            long unassignedSeqNo = -2L;
            Engine.DeleteResult deleteResult = new Engine.DeleteResult(e, currentVersion, -2L, !currentlyDeleted);
            return new DeletionStrategy(false, currentlyDeleted, -2L, -1L, deleteResult);
        }

        static DeletionStrategy processNormally(boolean currentlyDeleted, long seqNoOfDeletion, long versionOfDeletion) {
            return new DeletionStrategy(true, currentlyDeleted, seqNoOfDeletion, versionOfDeletion, null);
        }

        public static DeletionStrategy processButSkipLucene(boolean currentlyDeleted, long seqNoOfDeletion, long versionOfDeletion) {
            return new DeletionStrategy(false, currentlyDeleted, seqNoOfDeletion, versionOfDeletion, null);
        }
    }

    private static final class IndexingStrategy {
        final boolean currentNotFoundOrDeleted;
        final boolean useLuceneUpdateDocument;
        final long seqNoForIndexing;
        final long versionForIndexing;
        final boolean indexIntoLucene;
        final Optional<Engine.IndexResult> earlyResultOnPreFlightError;

        private IndexingStrategy(boolean currentNotFoundOrDeleted, boolean useLuceneUpdateDocument, boolean indexIntoLucene, long seqNoForIndexing, long versionForIndexing, Engine.IndexResult earlyResultOnPreFlightError) {
            assert (!useLuceneUpdateDocument || indexIntoLucene) : "use lucene update is set to true, but we're not indexing into lucene";
            assert (!(indexIntoLucene && earlyResultOnPreFlightError != null)) : "can only index into lucene or have a preflight result but not both.indexIntoLucene: " + indexIntoLucene + "  earlyResultOnPreFlightError:" + earlyResultOnPreFlightError;
            this.currentNotFoundOrDeleted = currentNotFoundOrDeleted;
            this.useLuceneUpdateDocument = useLuceneUpdateDocument;
            this.seqNoForIndexing = seqNoForIndexing;
            this.versionForIndexing = versionForIndexing;
            this.indexIntoLucene = indexIntoLucene;
            this.earlyResultOnPreFlightError = earlyResultOnPreFlightError == null ? Optional.empty() : Optional.of(earlyResultOnPreFlightError);
        }

        static IndexingStrategy optimizedAppendOnly(long seqNoForIndexing) {
            return new IndexingStrategy(true, false, true, seqNoForIndexing, 1L, null);
        }

        static IndexingStrategy skipDueToVersionConflict(VersionConflictEngineException e, boolean currentNotFoundOrDeleted, long currentVersion) {
            Engine.IndexResult result = new Engine.IndexResult(e, currentVersion);
            return new IndexingStrategy(currentNotFoundOrDeleted, false, false, -2L, -1L, result);
        }

        static IndexingStrategy processNormally(boolean currentNotFoundOrDeleted, long seqNoForIndexing, long versionForIndexing) {
            return new IndexingStrategy(currentNotFoundOrDeleted, !currentNotFoundOrDeleted, true, seqNoForIndexing, versionForIndexing, null);
        }

        static IndexingStrategy overrideExistingAsIfNotThere(long seqNoForIndexing, long versionForIndexing) {
            return new IndexingStrategy(true, true, true, seqNoForIndexing, versionForIndexing, null);
        }

        static IndexingStrategy processButSkipLucene(boolean currentNotFoundOrDeleted, long seqNoForIndexing, long versionForIndexing) {
            return new IndexingStrategy(currentNotFoundOrDeleted, false, false, seqNoForIndexing, versionForIndexing, null);
        }
    }

    static enum OpVsLuceneDocStatus {
        OP_NEWER,
        OP_STALE_OR_EQUAL,
        LUCENE_DOC_NOT_FOUND;

    }

    @SuppressForbidden(reason="reference counting is required here")
    private static final class ExternalSearcherManager
    extends ReferenceManager<IndexSearcher> {
        private final SearcherFactory searcherFactory;
        private final SearcherManager internalSearcherManager;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExternalSearcherManager(SearcherManager internalSearcherManager, SearcherFactory searcherFactory) throws IOException {
            IndexSearcher acquire = (IndexSearcher)internalSearcherManager.acquire();
            try {
                IndexReader indexReader = acquire.getIndexReader();
                assert (indexReader instanceof ElasticsearchDirectoryReader) : "searcher's IndexReader should be an ElasticsearchDirectoryReader, but got " + indexReader;
                indexReader.incRef();
                this.current = SearcherManager.getSearcher(searcherFactory, indexReader, null);
            }
            finally {
                internalSearcherManager.release(acquire);
            }
            this.searcherFactory = searcherFactory;
            this.internalSearcherManager = internalSearcherManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IndexSearcher refreshIfNeeded(IndexSearcher referenceToRefresh) throws IOException {
            this.internalSearcherManager.maybeRefreshBlocking();
            IndexSearcher acquire = (IndexSearcher)this.internalSearcherManager.acquire();
            try {
                IndexReader previousReader = referenceToRefresh.getIndexReader();
                assert (previousReader instanceof ElasticsearchDirectoryReader) : "searcher's IndexReader should be an ElasticsearchDirectoryReader, but got " + previousReader;
                IndexReader newReader = acquire.getIndexReader();
                if (newReader == previousReader) {
                    IndexSearcher indexSearcher = null;
                    return indexSearcher;
                }
                newReader.incRef();
                IndexSearcher indexSearcher = SearcherManager.getSearcher(this.searcherFactory, newReader, previousReader);
                return indexSearcher;
            }
            finally {
                this.internalSearcherManager.release(acquire);
            }
        }

        @Override
        protected boolean tryIncRef(IndexSearcher reference) {
            return reference.getIndexReader().tryIncRef();
        }

        @Override
        protected int getRefCount(IndexSearcher reference) {
            return reference.getIndexReader().getRefCount();
        }

        @Override
        protected void decRef(IndexSearcher reference) throws IOException {
            reference.getIndexReader().decRef();
        }
    }
}

