/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ReferenceManager;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.Engine;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.store.Store;
import org.apache.logging.log4j.Logger;

final class EngineSearcher
extends Engine.Searcher {
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final Store store;
    private final Logger logger;
    private final ReferenceManager<IndexSearcher> referenceManager;

    EngineSearcher(String source, ReferenceManager<IndexSearcher> searcherReferenceManager, Store store, Logger logger) throws IOException {
        super(source, searcherReferenceManager.acquire());
        this.store = store;
        this.logger = logger;
        this.referenceManager = searcherReferenceManager;
    }

    @Override
    public void close() {
        if (!this.released.compareAndSet(false, true)) {
            this.logger.warn("Searcher was released twice", (Throwable)new IllegalStateException("Double release"));
            return;
        }
        try {
            this.referenceManager.release(this.searcher());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot close", e);
        }
        catch (AlreadyClosedException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.store.decRef();
        }
    }
}

