/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Tokenizer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.PreConfiguredAnalysisComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.TokenFilterFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.TokenizerFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public final class PreConfiguredTokenizer
extends PreConfiguredAnalysisComponent<TokenizerFactory> {
    private final Function<Version, Tokenizer> create;
    private final Function<Version, TokenFilterFactory> multiTermComponent;

    public static PreConfiguredTokenizer singleton(String name, Supplier<Tokenizer> create, @Nullable Supplier<TokenFilterFactory> multiTermComponent) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.ONE, version -> (Tokenizer)create.get(), multiTermComponent == null ? null : version -> (TokenFilterFactory)multiTermComponent.get());
    }

    public static PreConfiguredTokenizer luceneVersion(String name, Function<org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Version, Tokenizer> create, @Nullable Function<org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Version, TokenFilterFactory> multiTermComponent) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.LUCENE, version -> (Tokenizer)create.apply(version.luceneVersion), multiTermComponent == null ? null : version -> (TokenFilterFactory)multiTermComponent.apply(version.luceneVersion));
    }

    public static PreConfiguredTokenizer elasticsearchVersion(String name, Function<Version, Tokenizer> create, @Nullable Function<Version, TokenFilterFactory> multiTermComponent) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH, create, multiTermComponent);
    }

    private PreConfiguredTokenizer(String name, PreBuiltCacheFactory.CachingStrategy cache, Function<Version, Tokenizer> create, @Nullable Function<Version, TokenFilterFactory> multiTermComponent) {
        super(name, cache);
        this.create = create;
        this.multiTermComponent = multiTermComponent;
    }

    public boolean hasMultiTermComponent() {
        return this.multiTermComponent != null;
    }

    @Override
    protected TokenizerFactory create(final Version version) {
        if (this.multiTermComponent != null) {
            return new MultiTermAwareTokenizerFactory(){

                @Override
                public Tokenizer create() {
                    return (Tokenizer)PreConfiguredTokenizer.this.create.apply(version);
                }

                @Override
                public Object getMultiTermComponent() {
                    return PreConfiguredTokenizer.this.multiTermComponent.apply(version);
                }
            };
        }
        return () -> this.create.apply(version);
    }

    private static interface MultiTermAwareTokenizerFactory
    extends TokenizerFactory,
    MultiTermAwareComponent {
    }
}

