/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.CharArraySet;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.Environment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.Analysis;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.FingerprintAnalyzer;

public class FingerprintAnalyzerProvider
extends AbstractIndexAnalyzerProvider<Analyzer> {
    public static ParseField SEPARATOR = new ParseField("separator", new String[0]);
    public static ParseField MAX_OUTPUT_SIZE = new ParseField("max_output_size", new String[0]);
    public static int DEFAULT_MAX_OUTPUT_SIZE = 255;
    public static CharArraySet DEFAULT_STOP_WORDS = CharArraySet.EMPTY_SET;
    public static final char DEFAULT_SEPARATOR = ' ';
    private final FingerprintAnalyzer analyzer;

    public FingerprintAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        char separator = FingerprintAnalyzerProvider.parseSeparator(settings);
        int maxOutputSize = settings.getAsInt(MAX_OUTPUT_SIZE.getPreferredName(), DEFAULT_MAX_OUTPUT_SIZE);
        CharArraySet stopWords = Analysis.parseStopWords(env, indexSettings.getIndexVersionCreated(), settings, DEFAULT_STOP_WORDS);
        this.analyzer = new FingerprintAnalyzer(stopWords, separator, maxOutputSize);
    }

    @Override
    public FingerprintAnalyzer get() {
        return this.analyzer;
    }

    public static char parseSeparator(Settings settings) throws IllegalArgumentException {
        String customSeparator = settings.get(SEPARATOR.getPreferredName());
        if (customSeparator == null) {
            return ' ';
        }
        if (customSeparator.length() == 1) {
            return customSeparator.charAt(0);
        }
        throw new IllegalArgumentException("Setting [separator] must be a single, non-null character. [" + customSeparator + "] was provided.");
    }
}

