/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.CopyOnWriteHashMap;

public final class FieldNameAnalyzer
extends DelegatingAnalyzerWrapper {
    private final Map<String, Analyzer> analyzers;

    public FieldNameAnalyzer(Map<String, Analyzer> analyzers) {
        super(Analyzer.PER_FIELD_REUSE_STRATEGY);
        this.analyzers = CopyOnWriteHashMap.copyOf(analyzers);
    }

    public Map<String, Analyzer> analyzers() {
        return this.analyzers;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        Analyzer analyzer = this.analyzers.get(fieldName);
        if (analyzer != null) {
            return analyzer;
        }
        throw new IllegalArgumentException("Field [" + fieldName + "] has no associated analyzer");
    }
}

