/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;

public class ByteBufferStreamInput
extends StreamInput {
    private final ByteBuffer buffer;

    public ByteBufferStreamInput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.buffer.hasRemaining()) {
            throw new EOFException();
        }
        return this.buffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > (long)this.buffer.remaining()) {
            int ret = this.buffer.position();
            this.buffer.position(this.buffer.limit());
            return ret;
        }
        this.buffer.position((int)((long)this.buffer.position() + n));
        return n;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (this.buffer.remaining() < len) {
            throw new EOFException();
        }
        this.buffer.get(b, offset, len);
    }

    @Override
    public void reset() throws IOException {
        this.buffer.reset();
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    protected void ensureCanReadBytes(int length) throws EOFException {
        if (this.buffer.remaining() < length) {
            throw new EOFException("tried to read: " + length + " bytes but only " + this.buffer.remaining() + " remaining");
        }
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

