/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.health;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.health.ClusterShardHealth;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public final class ClusterIndexHealth
implements Iterable<ClusterShardHealth>,
Writeable,
ToXContentFragment {
    private final String index;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private final int activeShards;
    private final int relocatingShards;
    private final int initializingShards;
    private final int unassignedShards;
    private final int activePrimaryShards;
    private final ClusterHealthStatus status;
    private final Map<Integer, ClusterShardHealth> shards = new HashMap<Integer, ClusterShardHealth>();
    private static final String STATUS = "status";
    private static final String NUMBER_OF_SHARDS = "number_of_shards";
    private static final String NUMBER_OF_REPLICAS = "number_of_replicas";
    private static final String ACTIVE_PRIMARY_SHARDS = "active_primary_shards";
    private static final String ACTIVE_SHARDS = "active_shards";
    private static final String RELOCATING_SHARDS = "relocating_shards";
    private static final String INITIALIZING_SHARDS = "initializing_shards";
    private static final String UNASSIGNED_SHARDS = "unassigned_shards";
    private static final String SHARDS = "shards";
    private static final String PRIMARY_ACTIVE = "primary_active";

    public ClusterIndexHealth(IndexMetaData indexMetaData, IndexRoutingTable indexRoutingTable) {
        this.index = indexMetaData.getIndex().getName();
        this.numberOfShards = indexMetaData.getNumberOfShards();
        this.numberOfReplicas = indexMetaData.getNumberOfReplicas();
        for (IndexShardRoutingTable shardRoutingTable : indexRoutingTable) {
            int shardId = shardRoutingTable.shardId().id();
            this.shards.put(shardId, new ClusterShardHealth(shardId, shardRoutingTable));
        }
        ClusterHealthStatus computeStatus = ClusterHealthStatus.GREEN;
        int computeActivePrimaryShards = 0;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedShards = 0;
        for (ClusterShardHealth shardHealth : this.shards.values()) {
            if (shardHealth.isPrimaryActive()) {
                ++computeActivePrimaryShards;
            }
            computeActiveShards += shardHealth.getActiveShards();
            computeRelocatingShards += shardHealth.getRelocatingShards();
            computeInitializingShards += shardHealth.getInitializingShards();
            computeUnassignedShards += shardHealth.getUnassignedShards();
            if (shardHealth.getStatus() == ClusterHealthStatus.RED) {
                computeStatus = ClusterHealthStatus.RED;
                continue;
            }
            if (shardHealth.getStatus() != ClusterHealthStatus.YELLOW || computeStatus == ClusterHealthStatus.RED) continue;
            computeStatus = ClusterHealthStatus.YELLOW;
        }
        if (this.shards.isEmpty()) {
            computeStatus = ClusterHealthStatus.RED;
        }
        this.status = computeStatus;
        this.activePrimaryShards = computeActivePrimaryShards;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
    }

    public ClusterIndexHealth(StreamInput in) throws IOException {
        this.index = in.readString();
        this.numberOfShards = in.readVInt();
        this.numberOfReplicas = in.readVInt();
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            ClusterShardHealth shardHealth = new ClusterShardHealth(in);
            this.shards.put(shardHealth.getId(), shardHealth);
        }
    }

    public String getIndex() {
        return this.index;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<Integer, ClusterShardHealth> getShards() {
        return this.shards;
    }

    @Override
    public Iterator<ClusterShardHealth> iterator() {
        return this.shards.values().iterator();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.numberOfShards);
        out.writeVInt(this.numberOfReplicas);
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeByte(this.status.value());
        out.writeVInt(this.shards.size());
        for (ClusterShardHealth shardHealth : this) {
            shardHealth.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(NUMBER_OF_SHARDS, this.getNumberOfShards());
        builder.field(NUMBER_OF_REPLICAS, this.getNumberOfReplicas());
        builder.field(ACTIVE_PRIMARY_SHARDS, this.getActivePrimaryShards());
        builder.field(ACTIVE_SHARDS, this.getActiveShards());
        builder.field(RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(UNASSIGNED_SHARDS, this.getUnassignedShards());
        if (SHARDS.equals(params.param("level", "indices"))) {
            builder.startObject(SHARDS);
            for (ClusterShardHealth shardHealth : this.shards.values()) {
                builder.startObject(Integer.toString(shardHealth.getId()));
                builder.field(STATUS, shardHealth.getStatus().name().toLowerCase(Locale.ROOT));
                builder.field(PRIMARY_ACTIVE, shardHealth.isPrimaryActive());
                builder.field(ACTIVE_SHARDS, shardHealth.getActiveShards());
                builder.field(RELOCATING_SHARDS, shardHealth.getRelocatingShards());
                builder.field(INITIALIZING_SHARDS, shardHealth.getInitializingShards());
                builder.field(UNASSIGNED_SHARDS, shardHealth.getUnassignedShards());
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }
}

