/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.action.index;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchTimeoutException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.IndicesAdminClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.Mapping;

public class MappingUpdatedAction
extends AbstractComponent {
    public static final Setting<TimeValue> INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING = Setting.positiveTimeSetting("indices.mapping.dynamic_timeout", TimeValue.timeValueSeconds(30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private IndicesAdminClient client;
    private volatile TimeValue dynamicMappingUpdateTimeout;

    @Inject
    public MappingUpdatedAction(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.dynamicMappingUpdateTimeout = INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING, this::setDynamicMappingUpdateTimeout);
    }

    private void setDynamicMappingUpdateTimeout(TimeValue dynamicMappingUpdateTimeout) {
        this.dynamicMappingUpdateTimeout = dynamicMappingUpdateTimeout;
    }

    public void setClient(Client client) {
        this.client = client.admin().indices();
    }

    private PutMappingRequestBuilder updateMappingRequest(Index index, String type, Mapping mappingUpdate, TimeValue timeout) {
        if (type.equals("_default_")) {
            throw new IllegalArgumentException("_default_ mapping should not be updated");
        }
        return (PutMappingRequestBuilder)((PutMappingRequestBuilder)this.client.preparePutMapping(new String[0]).setConcreteIndex(index).setType(type).setSource(mappingUpdate.toString(), XContentType.JSON).setMasterNodeTimeout(timeout)).setTimeout(timeout);
    }

    public void updateMappingOnMaster(Index index, String type, Mapping mappingUpdate) {
        this.updateMappingOnMaster(index, type, mappingUpdate, this.dynamicMappingUpdateTimeout);
    }

    public void updateMappingOnMaster(Index index, String type, Mapping mappingUpdate, TimeValue timeout) {
        if (!((PutMappingResponse)this.updateMappingRequest(index, type, mappingUpdate, timeout).get()).isAcknowledged()) {
            throw new ElasticsearchTimeoutException("Failed to acknowledge mapping update within [" + timeout + "]", new Object[0]);
        }
    }
}

