/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ShardOperationFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;

public class DefaultShardOperationFailedException
implements ShardOperationFailedException {
    private static final String INDEX = "index";
    private static final String SHARD_ID = "shard";
    private static final String REASON = "reason";
    private static final ConstructingObjectParser<DefaultShardOperationFailedException, Void> PARSER = new ConstructingObjectParser("failures", true, arg -> new DefaultShardOperationFailedException((String)arg[0], (Integer)arg[1], (Throwable)arg[2]));
    private String index;
    private int shardId;
    private Throwable reason;
    private RestStatus status;

    protected DefaultShardOperationFailedException() {
    }

    public DefaultShardOperationFailedException(ElasticsearchException e) {
        Index index = e.getIndex();
        this.index = index == null ? null : index.getName();
        ShardId shardId = e.getShardId();
        this.shardId = shardId == null ? -1 : shardId.id();
        this.reason = e;
        this.status = e.status();
    }

    public DefaultShardOperationFailedException(String index, int shardId, Throwable reason) {
        this.index = index;
        this.shardId = shardId;
        this.reason = reason;
        this.status = ExceptionsHelper.status(reason);
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    public int shardId() {
        return this.shardId;
    }

    @Override
    public String reason() {
        return ExceptionsHelper.detailedMessage(this.reason);
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Override
    public Throwable getCause() {
        return this.reason;
    }

    public static DefaultShardOperationFailedException readShardOperationFailed(StreamInput in) throws IOException {
        DefaultShardOperationFailedException exp = new DefaultShardOperationFailedException();
        exp.readFrom(in);
        return exp;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.index = in.readString();
        }
        this.shardId = in.readVInt();
        this.reason = in.readException();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.index == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.index);
        }
        out.writeVInt(this.shardId);
        out.writeException(this.reason);
        RestStatus.writeTo(out, this.status);
    }

    public String toString() {
        return "[" + this.index + "][" + this.shardId + "] failed, reason [" + this.reason() + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SHARD_ID, this.shardId());
        builder.field(INDEX, this.index());
        builder.field("status", this.status.name());
        if (this.reason != null) {
            builder.startObject(REASON);
            ElasticsearchException.generateThrowableXContent(builder, params, this.reason);
            builder.endObject();
        }
        return builder;
    }

    public static DefaultShardOperationFailedException fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(INDEX, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(SHARD_ID, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField(REASON, new String[0]));
    }
}

