/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DoubleValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DoubleValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.util.ShapeFieldCache;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.util.ShapeFieldCacheProvider;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceCalculator;
import org.locationtech.spatial4j.shape.Point;

public class ShapeFieldCacheDistanceValueSource
extends DoubleValuesSource {
    private final SpatialContext ctx;
    private final Point from;
    private final ShapeFieldCacheProvider<Point> provider;
    private final double multiplier;

    public ShapeFieldCacheDistanceValueSource(SpatialContext ctx, ShapeFieldCacheProvider<Point> provider, Point from, double multiplier) {
        this.ctx = ctx;
        this.from = from;
        this.provider = provider;
        this.multiplier = multiplier;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.provider + ", " + this.from + ")";
    }

    @Override
    public DoubleValues getValues(final LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        double nullValue = this.ctx.isGeo() ? 180.0 * this.multiplier : Double.MAX_VALUE;
        return DoubleValues.withDefault(new DoubleValues(){
            private final ShapeFieldCache<Point> cache;
            private final Point from;
            private final DistanceCalculator calculator;
            private List<Point> currentVals;
            {
                this.cache = ShapeFieldCacheDistanceValueSource.this.provider.getCache(readerContext.reader());
                this.from = ShapeFieldCacheDistanceValueSource.this.from;
                this.calculator = ShapeFieldCacheDistanceValueSource.this.ctx.getDistCalc();
            }

            @Override
            public double doubleValue() throws IOException {
                double v = this.calculator.distance(this.from, this.currentVals.get(0));
                for (int i = 1; i < this.currentVals.size(); ++i) {
                    v = Math.min(v, this.calculator.distance(this.from, this.currentVals.get(i)));
                }
                return v * ShapeFieldCacheDistanceValueSource.this.multiplier;
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.currentVals = this.cache.getShapes(doc);
                return this.currentVals != null;
            }
        }, nullValue);
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeFieldCacheDistanceValueSource that = (ShapeFieldCacheDistanceValueSource)o;
        if (!this.ctx.equals(that.ctx)) {
            return false;
        }
        if (!this.from.equals(that.from)) {
            return false;
        }
        if (!this.provider.equals(that.provider)) {
            return false;
        }
        return this.multiplier == that.multiplier;
    }

    @Override
    public int hashCode() {
        return this.from.hashCode();
    }
}

